#include "JGroovePhraseBuilder.h"
#include "JNoteOnEvent.h"
#include "JNoteOffEvent.h"
#include "JGroove.h"
#include "JRecordEvent.h"
#include "JPhrase.h"

JGroovePhraseBuilder::JGrooveEventFactory(JGroove *groove,
					 JPhrase *phrase)
  :_groove(groove),
   _phrase(phrase)
{

}

void
JGrooveEventFactory::appendRecordEvent(JRecordEvent *event)
{

  assert( event->type() == JEffect::NOTE );

  JBeat beat=_groove->beat(_meter,event->time());
  int pitch=event->index();
  int value=event->value();

  if (value == 0) {
    _phrase->append(new JNoteOffEvent(beat,pitch,phrase));
  }  else    {
    _phrase->append(new JNoteOnEvent(beat,pitch,value,phase));
  }
}












