#include <string.h>
#include <iostream.h>

#include "JGestureFactory.h"
#include "JNoteGesture.h"
#include "JEffectEventGesture.h"

#include "JError.h"

JGestureFactory * JGestureFactory::_the=0;


JGestureFactory::JGestureFactory()
{

  assert(_the == 0);
  _protoList = new JList<JGesture>();

  addPrototype(new JNoteGesture(JBeat(1),
				JDuration(1),
				64,120));

  addPrototype(new JEffectEventGesture(JBeat(1),
				       JMidiOutEvent(JMidiOutType::NO_EFFECT)
				       )
	       );

  _the = this;
}


JGestureFactory::~JGestureFactory()
{
  delete _protoList;
}

JGestureFactory * 
JGestureFactory::the()
{
  if (_the==0) _the = new JGestureFactory();
  return _the;
}

void
JGestureFactory::addPrototype(JGesture *g)
{
  _protoList->add(g,false);
}

JGesture *
JGestureFactory::createGesture(const char *name)
{
  
  JListIterator<JGesture> iter(_protoList);

  JGesture *g;

  while(  (g=iter.next()) != 0) {
    if ( strncmp(g->typeName(),name,60) == 0) {
      return g->clone();
    }
  }

  return 0;
}


