#ifndef _JMidiInEvent_H
#define _JMidiInEvent_H

#include "JMidiType.h"

class ostream;

class JMidiInEvent
{
public:

  //  JMidiInEvent(const JMidiInEvent &);
  JMidiInEvent(unsigned char *buf=0):_buf(buf){;}

  JMidiType type() const  {  
    if ( rawMidiType() == NOTEON ||
	 rawMidiType() == NOTEOFF) return NOTE; 
    return (JMidiType)rawMidiType(); 
  }

  int value() const;

  const char *name() const { return "MidiInEvent"; }

  JMidiInEvent *midiEvent() {return this;}

  void debugOut(ostream &) const;


  /// MY VERY OWN
  void setBuffer(unsigned char *buf){ _buf=buf;}

  unsigned char rawMidiType() const { return _buf[0] & 0xf0 ; }  
  unsigned char pitch() const    { return _buf[1]; }
  unsigned char velocity() const { return _buf[2]; }
  unsigned char pressure() const { return _buf[1]; }
  unsigned char program() const  { return _buf[1]; }
  unsigned char controller()const { return _buf[1];}
  unsigned char controllerValue() const { return _buf[2]; }

  int  pitchBend() const 
  { return (((_buf[2] & 0x7f) << 7) | (_buf[1] & 0x7f)) - 8192; }


protected:
  unsigned char *_buf;
};

ostream & operator << (ostream &,const JMidiInEvent &);


class JMidiNoteEvent:public JMidiInEvent
{
public:

  JMidiNoteEvent(int pitch,int vel)
    {
      _buf = new unsigned char[4];

      if (vel != 0) 
	_buf[0]=NOTEON;
      else
	_buf[0]=NOTEOFF;

      _buf[1]=pitch;
      _buf[2]=vel;
    }
};


#endif


