#include <iostream.h>
#include <unistd.h>
#include <math.h>

#include "jam/JMidiIn.h"
#include "jam/JVoice.h"
#include "jam/JMidiInDriver.h"
#include "jam/JMapper.h"

#include "jam/linux/JITScheduler.h"
#include "jam/linux/JOSSDeviceManager.h"  //  /dev/sequencer interface

#include "jam/JBeat.h"

class CyclicBeatArray
{
public:
  CyclicBeatArray(int size):_size(size),_first(0)
  {
  _beat= new JBeat[_size];
  }
  JBeat at(int i) { assert(i < _size); return _beat[(_first-i+_size)%_size]; }
  void  add(JBeat b) 
  { 
    _first = (_first+1)%_size;
    _beat[_first]=b;
  }
private:
  JBeat *_beat;
  int    _size;
  int    _first;
};


class Foot:public JObserver<JMidiInEvent,void>
{

public:
  Foot(JITScheduler *sched,int histSize,int countSize)
    :_historySize(histSize),
     _countSize(countSize),
     _history(histSize),
     _sched(sched),
     _n(0)
  {
    _count= new int[countSize];
  }
  void handle(JMidiInEvent );
  bool inSnyc() const;
  const char *name() const { return "Foot"; }

private:
  void newRef(JBeat b);
  int              _historySize;
  int              _countSize;
  CyclicBeatArray  _history;
  JITScheduler *   _sched;
  int    *         _count;
  int              _n;
  JBeat            _ref;
};


void
Foot::newRef(JBeat b)
{

  for (int i=0; i<_countSize ;i++) 
    _count[i]=0;

  for(int i=0; i < _historySize ; i++) {
    _history.add(b);
  }

}

void
Foot::handle(JMidiInEvent e)
{
  if (e.type() != NOTEON) return;
  if (e.velocity() == 0) return;

  JBeat b = _sched->beatNow();

  if (_n==0) {
    _ref=b;
    _n++;
    return;
  } else if (_n == 1) {
    double d = b.rep() - _ref.rep();

    double bLen;


    newRef(b);
    _n++;
    return;
  }

  //  cout << b << endl;

  for(int i=0; i < _historySize ; i++) {
    JDuration d= b - _history.at(i);
    // cout << _history.at(i) << " ";
    d.quantize(12);
    int index = (int) rint(d.rep()*12);

    if (index>0 && index <_countSize) {
      _count[index] += 1;
    }
  }

  cout << endl;

  _history.add(b);
  
  int c  = 0;

  for(int i=0 ; i <60 ; i++) {
    if (_count[i]>c) c =_count[i];
  }

  cout << "" << endl;
  for(int i=0 ; i <60 ; i++) {
    cout << i%6 ;
  }
  cout << endl;

  double delta=c/20.0;
  double thres=delta;
  bool more = true;
  char buff[90];

  while(more) {
    more=false;
    for(int i=0 ; i <60 ; i++) {
      if (_count[i] > thres) { more=true; buff[i]='X'; }
      else buff[i]=' ';
    }
    buff[60]='\0';
    cout << buff << endl ;
    thres += delta;
  }
}


int main()
{

  JOSSDeviceManager manager;

  // Wrapper for the midi in stream

  JMidiIn *midiIn=manager.midiIn();

  // To manage the calling of the midiIn.readMidi()

  JMidiInDriver midiInDriver(midiIn);

  // Interupt timer with 1/100 sec time slice

  JITScheduler sched;

  sched.launch(JTime(10));

  // Connect the midiInDriver

  sched.setSliceClient(&midiInDriver);
  sched.start();

  // device manager knows about devices (wow) !
  JDevice *device=manager.device(1);

  // We can have a voice with no track providing we do not try to record !
  JMapper *mapper = new JMapper(device,
				DEFAULT);

  JVoice voice(mapper);

  midiIn->attach(&voice);
  
  Foot foot(&sched,20,120);

  midiIn->attach(&foot);

  cout << " ^C to quit " << endl;

  while(1);

}

