#include <iostream.h>
#include "rcorblk.h"
#include "beatblk.h"

// Default constructor
rhythm_corr_block_c::rhythm_corr_block_c(){
  main_match_array_ptr = 0;
  main_gap_array_ptr = 0;
  comp_gap_array_ptr = 0;
  total_shift_ptr = 0;
  linkR_ptr = 0;
  linkL_ptr = 0;
}

// Other Constructor
rhythm_corr_block_c::rhythm_corr_block_c(int corr_weight_i, int group_i,
													 int *fraction_array_p, int no_matches_i,
													 int no_main_gaps_i, int no_comp_gaps_i){
	 char d;

	 corr_weight_int = corr_weight_i;
	 group_int = group_i;
	 total_shift_ptr = new beat_block_c(fraction_array_p);
	 if(total_shift_ptr == 0){
		cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		cin.get(d);
	 }
	 no_matches_int = no_matches_i;
	 no_main_gaps_int = no_main_gaps_i;
	 no_comp_gaps_int = no_comp_gaps_i;
	 if(no_matches_i > 0){
		main_match_array_ptr = new beat_block_c[no_matches_i];
		if(main_match_array_ptr == NULL){
		  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		  cin.get(d);
		}
	 }else
		main_match_array_ptr = NULL;

	 if(no_main_gaps_i > 0){
		main_gap_array_ptr = new beat_block_c[no_main_gaps_i];
		if(main_gap_array_ptr == NULL){
		  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		  cin.get(d);
		}
	 }else
		main_gap_array_ptr = NULL;

	 if(no_comp_gaps_i > 0){
		comp_gap_array_ptr = new beat_block_c[no_comp_gaps_i];
		if(comp_gap_array_ptr == NULL){
		  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		  cin.get(d);
		}
	 }else
		comp_gap_array_ptr = NULL;
	 linkR_ptr = NULL;
	 linkL_ptr = NULL;
}

// Change right rhythm correlation block function //
rhythm_corr_block_c *rhythm_corr_block_c::change_linkR
						  (rhythm_corr_block_c *linkR_p){
  rhythm_corr_block_c *tmp_p;
  tmp_p = linkR_ptr;
  linkR_ptr = linkR_p;

  return tmp_p;
}

// Change left rhythm correlation block function //
rhythm_corr_block_c *rhythm_corr_block_c::change_linkL
						  (rhythm_corr_block_c *linkL_p){
  rhythm_corr_block_c *tmp_p;
  tmp_p = linkL_ptr;
  linkL_ptr = linkL_p;

  return tmp_p;
}

