#include "JSequencer.h"
#include "JSequencerList.h"


void
JSequencerList::lowPriorityPrepend(JSequencer *seq)
{

  if (_first == 0) {
    prepend(seq);
    return;
  }

  SDLLNode *node=_first;
  JBeat t = seq->nextBeat();
  
  do {
    JBeat tNext = ((JSequencer *)(node->_ptr))->nextBeat();
    if ( tNext > t ) {
      SDLLNode *prev=node->_prev;
      SDLLNode *newNode = new SDLLNode(seq,prev,node);
      if (prev != 0) prev->_next=newNode;
      else _first=newNode;
      node->_prev=newNode;
      return;
    }
  } while( (node=node->_next) != 0);
  
  append(seq);

}

void
JSequencerList::sortFirst()
{

  // sort first entry by finding the correct place and
  // grafting the Linled list node into the correct place.

  // Should be quicker then doing a whole bubble sort ?
  // This is used duing play back so if you can make it quick tis good

  assert(_first != 0);

  SDLLNode *node=_first->_next;
  if (node == 0 ) return;
  JBeat t= ((JSequencer *)(_first->_ptr))->nextBeat();
  JBeat tNext = ((JSequencer *)(node->_ptr))->nextBeat();
  if (tNext >= t) return; 

  // Disconnect the head 
  node->_prev=0;
  
  SDLLNode *oldFirst=_first;  
  _first=node;
  
  while( (node=node->_next) != 0)
    {
      tNext = ((JSequencer *)(node->_ptr))->nextBeat();
      if ( tNext >= t )
	{
	  node->_prev->_next=oldFirst;
	  oldFirst->_prev=node->_prev;
	  oldFirst->_next=node;
	  node->_prev=oldFirst;
	  return;
	}
    }
  
  // Put it at the end.
  oldFirst->_next=0;
  oldFirst->_prev=_last;
  _last->_next=oldFirst;
  _last=oldFirst;
}





void
JSequencerList::sortAll()
{
  // Bubbly sort by swapping link list node pointers
  // Well can you think of anything better ?
  // Not used during playback
  // Very naughty cast of types please close your eyes.

  SDLLNode *topNode=_first;

  while( topNode != 0 )
    {
      JBeat smallBeat= ((JSequencer *)(topNode->_ptr))->nextBeat();
      SDLLNode *smallNode = topNode;
      SDLLNode *node = topNode->_next;

      while ( node != 0 )
	{
	  JBeat t=((JSequencer *)(node->_ptr))->nextBeat();
	  if ( t < smallBeat)
	    {
	      smallBeat=t;
	      smallNode=node;
	    }
	  node=node->_next;
	}
      
      // smallNode is the smallest 
      if ( smallNode != topNode )
	{
	  void * tmp=topNode->_ptr;
	  topNode->_ptr = smallNode->_ptr;
	  smallNode->_ptr = tmp;
	}

      topNode=topNode->_next;
    }

}
