#include <qapp.h>
#include <qpushbt.h>
#include <qtooltip.h>
#include <qtabdlg.h>
#include <qbttngrp.h>
#include <qradiobt.h>

#include "jam/JMapper.h"

#include "QJVoiceWidget.h"
#include "QJChannelWidget.h"
#include "QJMapperWidget.h"


#include "jam/JVoice.h"
#include "jam/JFocus.h"
#include "jam/JContext.h"
#include "rep/JMidiType.h"

QJVoiceWidget::QJVoiceWidget(JContext *context,
			     QWidget *parent, 
			     const char *name )
  : QWidget( parent, name ),
    _channelWgt(0),
    _mapperWgt(0),
    _context(context)

{
  handle(context->focus());
}


QJVoiceWidget::~QJVoiceWidget()
{

}


void
QJVoiceWidget::handle(const JFocus *focus)
{

  JVoice *voice = focus->voice();
  if (voice == _voice) return;
 
  _voice = voice;

  if (  _mapperWgt ) delete _mapperWgt;
  
  _mapperWgt = new QJMapperWidget(voice,
				  this ,"map");
  

  if (_channelWgt) delete _channelWgt;

  _channelWgt=new QJChannelWidget(voice,this);

  _mapperWgt->move(12,8);

  _channelWgt->move(10,76);

  adjustSize();
  _mapperWgt->show();
  _channelWgt->show();
}

void
QJVoiceWidget::resetVoice()
{
  _voice->handle(JMidiOutEvent(JMidiOutType::RESET_EFFECT));
}

void 
QJVoiceWidget::myQuit()
{
  close();
}


// void
// QJVoiceWidget::keyPressEvent(QKeyEvent *key)
// {

//   debug(" Press %c ",key->ascii());
//   //  _voice.knobTable()->keyPress(key->ascii());
//   //  key->ignore();

// }



// void
// QJVoiceWidget::keyReleaseEvent(QKeyEvent *key)
// {


//   debug(" Release %c ",key->ascii());
//   //  _voice.knobTable()->keyRelease(key->ascii());
//   //key->ignore();

// }
















