#ifndef _QJSlider_H
#define _QJSlider_H

#include <qwidget.h>
#include "jam/JEffect.h"

class JEffect;
class QSlider;
class QLCDNumber;
class QLabel;
class QPushButton;
class JMidiOut;

class QJSlider:public QWidget
{
  ///
  Q_OBJECT
public:
  QJSlider(JEffect *effect,
	   JMidiOut *midiOut,
	   QWidget* parent=0, 
	   const char* name=0,
	   WFlags f=0);

  ///
  void resizeEvent(QResizeEvent *);

///
public  slots:    
  void setEffect(int value);    /// send value to target 
  void selectEffect(bool);      /// select this effect

protected:
  void timerEvent(QTimerEvent *);

  QLCDNumber  *      _lcd;
  QSlider     *      _slider;
  QPushButton *      _label;

  JEffect     *      _effect;
  JMidiOut    *      _midiOut;

  /// _on=FALSE stops sending value to target (internal use)
  bool               _on;      
};


#endif


