#include <qlayout.h>
#include <qspinbox.h>
#include "QJPhraseLoopWidget.h"
#include "QJBPTWidget.h"
#include "jam/JContext.h"
#include "jam/JMeter.h"
#include "jam/JFocus.h"
#include "jam/JPhrase.h"

QJPhraseLoopWidget::QJPhraseLoopWidget(QWidget *parent,JContext *context)
  :QWidget(parent),
   _context(context),
   _leftBPT(context->meter(),"Phrase Left"),
   _rightBPT(context->meter(),"Phrase Right")
{

  _context->focus()->attach(this);

  QBoxLayout * layout = new QHBoxLayout(this);
  _left = new QJBPTWidget(this,&_leftBPT);
  _left->setFocusPolicy(StrongFocus);
  _leftBPT.attach(_left);
  _leftBPT.attach(this);
  layout->addWidget(_left);

  _right = new QJBPTWidget(this,&_rightBPT);
  _right->setFocusPolicy(StrongFocus);
  _rightBPT.attach(_right);
  _rightBPT.attach(this);
  layout->addWidget(_right);

  _loop = new QSpinBox(1,99999,1,this);
  layout->addWidget(_loop);

  connect(_loop,SIGNAL(valueChanged(int)),SLOT(valueChanged(int)));

  layout->addStretch(0);
  layout->activate();

  rebuild();

}

void 
QJPhraseLoopWidget::valueChanged(int)
{
  updatePhrase();
}

void
QJPhraseLoopWidget::handle(const JFocus *)
{
  rebuild();
}

void
QJPhraseLoopWidget::handle(const JBPT *)
{
  updatePhrase();
}


void
QJPhraseLoopWidget::rebuild()
{
  //  debug(" rebuild ");
  JPhrase *phrase = _context->focus()->phrase();
  if ( phrase != 0 ) {
    if (_context->focus()->phrase() != 0 ) {
      _leftBPT.setBeat(phrase->loopLeft(),true);
      _rightBPT.setBeat(phrase->loopRight(),true);
    }
    _loop->setValue(phrase->loopCount());
  }
  _left->update();
  _right->update();
}


void
QJPhraseLoopWidget::updatePhrase()
{
  debug(" update phrase ");
  JPhrase *phrase = _context->focus()->phrase();
  if ( phrase != 0 ) {
    phrase->setLoopLeft(_leftBPT.beat());
    phrase->setLoopRight(_rightBPT.beat());
    phrase->setLoopCount(_loop->value());
  }
}














