#include "QJOpenMidiCommand.h"
#include "jam/JContext.h"
#include "command/JConductorCommand.h"
#include "jam/JComposition.h"
#include "jam/JConductor.h"
#include "jam/JMidiFileReader.h"
#include "jam/JFocus.h"

#include <qfiledlg.h>

QJOpenMidiCommand::QJOpenMidiCommand(JContext *context):_context(context),
    _openDialog(new QFileDialog(".","*.mid",0,"OpenFileDialog",TRUE))
{


}

QJOpenMidiCommand::~QJOpenMidiCommand()
{
//  delete _openDialog;

}

void
QJOpenMidiCommand::execute()
{

  _openDialog->exec();
  
  QString fname=_openDialog->selectedFile();

  debug(" selected file is %s ",fname.data());

  if (fname.isNull()) return;

  _context->conductor()->handle(JConductorCommand::STOP);

  JComposition *comp = _context->composition();

  JMidiFileReader(comp,fname).processFile();
  
  JTrack * track= comp->trackList()->first();
  _context->focus()->setTrack(track);
  
  emit newComposition();

}

