#include <iostream.h>
#include <string.h>  // strcmp()

#include "JTrack.h"
//#include "JTrackNotator.h"
#include "seq/JMetaSequencer.h"
#include "JDLLDelete.h"
#include "JPhraseUpdate.h"
#include "JError.h"
#include "JComposition.h"
// #include "JVoiceManager.h"
#include "JPlayer.h"
#include "JVoice.h"
#include "rep/JReader.h"


JTrack::JTrack(JPlayer *voice,
	       JComposition *comp,
	       const char *name)
  : // JGesture(JBeat(0)),
   JName(name) ,
   _composition(comp) ,
   _player(voice),
   _update(this) 
{
} 

JTrack::~JTrack()
{
  if (_composition != 0) _composition->trackList()->clearItem(this,false); 
}

JTrack *
JTrack::clone()
{
  char buff[132];
  sprintf(buff,"%s_",name());

  JTrack *track=new JTrack(_player,_composition,buff);

  JPhraseListIterator iter(&_phraseList);
  JPhrase *phrase;

  while((phrase = iter.next()) != 0) {
    JPhrase *newPhrase = phrase->clone(track);
    track->phraseList()->append(newPhrase);
    newPhrase->attach(track);
  }

  return track;
}

JPhrase *
JTrack::newPhrase(JPart *part)
{

  JPhrase *phrase = new JPhrase(_player,this,part);
    
  _phraseList.add(phrase);

  phrase->attach(this);

  return phrase;
}


bool
JTrack::write(ostream &o) const
{
  o << "$Track" << endl ;
  o << name() << endl;

  JPhraseListIterator iter(&_phraseList);

  JPhrase *phrase;

  while( (phrase=iter.next()) != 0 ) {
    phrase->write(o);
  }

  o << "$End" << endl;

  return true;
}

bool
JTrack::read(JReader &in) 
{
  char buff[132];

  // My name first

  in.getString(buff,60);
  rename(buff);

  JToken tok;
  while(in.getToken(tok)) {
    JPhrase *phrase=0;
    switch (tok) {
    case T_Phrase:
      phrase = newPhrase(0);
      phrase->read(in);
      break;

    case T_End:
      return true;

    default:
      cout << __FILE__ << ":" <<  __LINE__ << " unexpected " << endl;
      return false;
    }
    
  }

  return true;
}



JMeter *
JTrack::meter()
{
  return _composition->meter();
}

const JMeter *
JTrack::meter() const
{
  return _composition->meter();
}

JPhraseList *
JTrack::phraseList()
{
  return &_phraseList;
}

const JPhraseList *
JTrack::phraseList() const
{
  return &_phraseList;
}


// JPart *
// JTrack::findPartOf(JPhrase *findMe)
// {

//   JPartListIterator  parts(&_partList);
  
//   JPart *part;
  
//   while( (part=parts.next()) != 0)
//     {
//       if (part->phraseList()->contains(findMe)) return part;
//     }
//   return 0;
// }



// JEditor *
// JTrack::editor()
// {
//   assert(0);
//   //  if (_editor == 0)
//     //    _editor=new JTrackEditor(this);

//   return _editor;
// }

JSequencer *
JTrack::createSequencer(JPlayer *player) const
{
  JPhraseListIterator iter(&_phraseList);
  return new JMetaSequencer(iter,player);
}


// JNotator *
// JTrack::createNotator(JScorePainter *p) const
// {
//   return new JTrackNotator(this,p);
// }
// JPhrase *
// JTrack::newPhrase()
// {
//   JPhrase *phrase=new JPhrase(this);
//   _phraseList.add(phrase);
//   return phrase;
// }



void
JTrack::handle(JPhraseUpdate update)
{
  _update.contain(update.lrRep());
  notifyObservers(_update);
  _update.done();
}


// ostream & operator <<(ostream &o,const JTrack &track)
// {
//   track.out(o);
//   return o;
// }





