#ifndef _JMidiFileReader_H
#define _JMidiFileReader_H

#include "JMidiFileProcessor.h"

class JComposition;
class JTrack;
class JPart;
class JPhrase;
class JEventPhraseBuilder;

#define MAX_TRACKS 32

class JMidiFileReader:public JMidiFileProcessor
{
public:
  JMidiFileReader(JComposition *comp,const char *filename);
  void initialize();
  // MMidiEventEventProcessor
  bool processEvent(const MidiEvent *event);
private:
  const char *    _filename;
  JComposition *  _comp;
  JTrack *        _track[MAX_TRACKS];
  JPart *         _part;
  JPhrase *       _phrase[MAX_TRACKS];
  JEventPhraseBuilder * _builder[MAX_TRACKS];
  double          _tempo;
};


#endif
