#ifndef _JEvent_H
#define _JEvent_H

#include "rep/JBeat.h"
#include "rep/JMidiType.h"

class JVertIterator;
class JBeat;
class JEventPhrase;
class JEffectNode;
class JSequencer;
class JPlayer;

class JEvent
{
public:

  JEvent();

  virtual ~JEvent();
  
  bool  isHead() const { return _prev == 0; }
  bool  isTail() const { return _next == 0; }
  bool  isTerminator() const { return _next == 0 || _prev == 0 ; }
  
  JVertIterator *       createVertIterator() const;
  JEvent *      next() { return _next; }
  JEvent *      prev() { return _prev; }
  const JEvent * next() const { return _next; }
  const JEvent * prev() const { return _prev; }
  const JBeat &        beat() const 
  {  return _beat; }

  JEffectNode * seekEffect(JMidiOutType type,int index = -1) const ;

protected:

  // add effect to the vertical list only.
  // if check is true check for duplicate type and modify value if found

  JEffectNode * addEffect(JMidiOutType type,
			  int index,
			  int value,
			  bool check);

  JEffectNode * topNode() { return _topNode; }

  //  JEventPhrase *     _phrase;    // My parent

  JEvent *           _next;      // neighbors
  JEvent *           _prev;

  JBeat              _beat;

friend class JEventPhrase;
friend class JEventPhraseIterator;
friend class JVertIterator;
friend class JEventPhraseController;

//   void setNext(JEvent *event) { _next=event; }
//   void setPrev(JEvent *event) { _prev=event; }

  JEffectNode  *_topNode; 

};

ostream & operator << (ostream &,const JEvent &);

#endif



