#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <iostream.h>

#include "JSysTime.h"

#include "JITScheduler.h"
#include "jam/JTimerClient.h"
#include "rep/JBeat.h"


JTimerClient *         JITScheduler::_alarmClient=0;
JTimerClient *         JITScheduler::_sliceClient=0;
JSysInterval           JITScheduler::_sysSlice(JTime(10));
JTime                  JITScheduler::_tSlice(JTime(10));
double                 JITScheduler::_bpm=120.0;
double                 JITScheduler::_beatsPerSlice=0.02;
double                 JITScheduler::_beatNow(0);
double                 JITScheduler::_alarmBeat(1.0e32);
bool                   JITScheduler::_stoped=true;
JSysTime               JITScheduler::_tLast;


#ifdef STATISTICS
unsigned long          JITScheduler::_misses[MAX_TICKS];

void 
JITScheduler::statistics()
{
  cout << " JITScheduler how bad was it ? " << endl;
  for (int i=0; i < MAX_TICKS ; i++) {
    if ( _misses[i] != 0 ) {
      cout << " " << i << " ---> " << _misses[i] << endl;
    }
  }
}
#endif


JITScheduler::~JITScheduler()
{

#ifdef STATISTICS
  statistics();
#endif

}

void 
JITScheduler::launch(JTime slice)
{
  _tSlice=slice;
  _sysSlice=JSysInterval(slice);
  gettimeofday(&_tLast,0);
  signal(SIGALRM,handler);  
  setitimer(ITIMER_REAL, &_sysSlice, 0);
  setTempo(_bpm);
}


void 
JITScheduler::setTempo(double bpm)
{
  _bpm           = bpm;
  double beatPerSec=bpm/60.0;
  _beatsPerSlice = _sysSlice.realInterval()*beatPerSec;
}

void  
JITScheduler::handler(int id) 
{ 

#ifdef STATISTICS
  JSysTime tSys;
  gettimeofday(&tSys,0);
  JTime t = tSys.timeFrom(_tLast);
  int nTick = t.glitchs() / _tSlice.glitchs();
  assert(nTick>=0);
  assert(nTick < MAX_TICKS);
  _misses[nTick]++;
  _tLast=tSys;
#endif

  if (!_stoped) _beatNow += _beatsPerSlice;

#ifdef J_DEBUG
  cerr << "JITScheduler::handler" << endl;
#endif
    
  if (_sliceClient != 0) _sliceClient->interuptHandler(id); 
    
  if (_alarmClient != 0) {
    while(_beatNow >= _alarmBeat) {
      _alarmClient->interuptHandler(id); 
      if (_alarmClient == 0) break;
    }
  }

  // This could be done at the end
  signal(SIGALRM,handler);  
  setitimer(ITIMER_REAL, &_sysSlice, 0);
}

void
JITScheduler::stop()
{
  if (_stoped) return;
  _stoped=true;
}

void
JITScheduler::start()
{
  if (!_stoped) return;
  _stoped=false;
}


JBeat
JITScheduler::beatNow()  const
{
  return JBeat(_beatNow);
}

void 
JITScheduler::setNow(const JBeat &beat)
{
  _beatNow = beat.rep();

}

void
JITScheduler::setAlarmAt(const JBeat &when)
{
  _alarmBeat = when.rep();
}









