#include <qapp.h>

#include "qj/dirview.h"

#include "japp/JApplication.h" 
#include "jam/JContext.h"
#include "jam/JDeviceManager.h"
#include "jam/JMidiIn.h"
#include "jam/JVoice.h"
#include "jam/JVoiceManager.h"

#include "qj/QJVoiceWidget.h"

int main( int argc, char ** argv ) {

  QApplication a( argc, argv );

  JDeviceManager *manager=JDeviceManager::the();

  JApplication japp;
  JContext  context;

  // this is the AWE32 on my box
  JVoiceManager::the()->setDefaultDevice(1);

  // Wrapper for the midi in stream

  JMidiIn *midiIn=manager->midiIn(0);

  JVoice *voice =   JVoiceManager::the()->newVoice();

  midiIn->attach(voice);

  QJVoiceWidget voiceWidget(&context);

  voiceWidget.show();


  QListView mw;
  a.setMainWidget( &mw );
  mw.setCaption( "Soundfont Browser" );
  mw.addColumn( "Name" );
  mw.addColumn( "Type" );
  mw.resize( 400, 400 );
  mw.setTreeStepSize( 20 );
  Directory * root = new Directory( &mw , "/DOSC/musak/sbk/" );
  root->setOpen( TRUE );
  mw.show();
  return a.exec();

}
