#include <iostream.h> // cout
#include <qapp.h>

#include "jam/JDeviceManager.h"  //  /dev/sequencer interface
#include "japp/JApplication.h"

#include "jam/JMidiIn.h"
#include "jam/JVoice.h"
#include "jam/JDevice.h"
#include "jam/JContext.h"
#include "jam/JVoiceManager.h"
#include "qj/QJVoiceWidget.h"

#include "qj/Piano.h"
#include "qj/QJKeyHandler.h"
#include "qj/QJIntToMidiIn.h"

int main(int argc,char **argv)
{
  QApplication a( argc, argv );

  // need to create the Device manager
  JDeviceManager *manager = JDeviceManager::the();

  JApplication japp;

  JContext *context      = new JContext;
	
  int nDev = manager->nOutDevice();
  int i;

  cout << "\n Supported Devices" << endl;
  for(i=0; i < nDev ; i++ ) {
    cout << "[" << i << "] " <<  manager->outDevice(i)->name() << endl;
  }

  do {
    cout << " Enter the device you want to torture :";
    cin  >> i;
  } while (i <0 && i >= nDev);

  JVoiceManager::the()->setDefaultDevice(i);

  // allocate a voice
  JVoice *voice =   JVoiceManager::the()->newVoice();

	
  // A piano widget
  Piano piano(6,24,0,"mybutton");

  // object to map the piano signals to a midiIn subject
  QJIntToMidiIn midiIn;

  // connect the midiIN to a voice
  midiIn.attach(voice);

  // create and show a control widget for the voice
  QJVoiceWidget voiceWidget(context);
  voiceWidget.show();
  

  // create an object to catch the key hits to be mapped onto
  // the virtual keyboard
  QJKeyHandler kh;

  // use this to catch events in the paino window and voice widget
  piano.installEventFilter(&kh);
  voiceWidget.installEventFilter(&kh);

  piano.resize(840,100);

  piano.connect(&kh,SIGNAL(noteOn(int)),SLOT(Down(int)));
  piano.connect(&kh,SIGNAL(noteOff(int)),SLOT(Up(int)));

  midiIn.connect(&kh,SIGNAL(noteOn(int)),SLOT(noteOn(int)));
  midiIn.connect(&kh,SIGNAL(noteOff(int)),SLOT(noteOff(int)));
  midiIn.connect(&piano,SIGNAL(noteOn(int)),SLOT(noteOn(int)));
  midiIn.connect(&piano,SIGNAL(noteOff(int)),SLOT(noteOff(int)));


  a.setMainWidget(&piano);
  piano.show();
  return a.exec();
}


