#ifndef _scale_analyse_c_h
#define _scale_analyse_c_h

// This file is an object called scale analyse //
// 16 dec 1997 Julian Sweeting //

class phrase_c;
class rhythm_block_c;
class flow_analyse_c;

class scale_analyse_c{
  public:
	 scale_analyse_c();
	 scale_analyse_c(phrase_c *phrase_p);
	 void scale_analyse();
	 void scale_analyse(rhythm_block_c *start_p, rhythm_block_c *end_p,
							  int closest_i);
	 void find_base_chord(flow_analyse_c *flow_p, int *fraction_array_p,
									  int *rfraction_array_p, int main_closest_int);
	 void remove_all();

	 void display_closest_scale();
	 int *base_chord(){return &base_chord_int[0];}
	 int *main_scale(){return &main_closest_scale_int[0][0];}
  private:
	 void set_base_chord_int(int key_note_i);
	 void eliminate_notes();
	 void identify_chords_to_fit(int main_closest_int);
	 void shift_12_2_array(int (*tmp_array_p)[2]);
	 void set_tmp_array(int (*tmp_array_p)[2], int (*scale_array_p)[2]);
	 void add_to_closest(int *array_p, int (*closest_array_p)[3]);
	 void remove_note_arrays();
	 void clear_12_2_array(int (*array_p)[2]);
	 void clear_scale_check();
	 void clear_main_closest();
	 void clear_sub_closest();
	 void identify_notes(rhythm_block_c *start_block_p,
								rhythm_block_c *end_block_p);
	 void initialise_scales();
	 void compare_scale(int (*scale_array_p)[2], int (*closest_array_p)[3]);

	 int base_chord_int[4];
	 
	 int main_closest_scale_int[6][3];
		// Stores 6 of: key note of scale, scale type, assesment //
	 int sub_closest_scale_int[6][3];
		// Stores 6 of: key note of scale, scale type, assesment //
	 int sub2_closest_scale_int[6][3];
		// Stores 6 of: key note of scale, scale type, assesment //

	 int phrase_notes_int[12];
	 int scale_check_int[12];
	 int tmp_int[12][2];
	 int tmp2_int[12][2];
	 int tmp3_int[12][2];
	 int major_s_int[13][2];
	 int minor_harmonic_s_int[13][2];

	 // Not used //
	 int minor_melodic_s_int[12];

	 int no_first_notes_int;
	 int no_last_notes_int;
	 int *first_note_ptr;
	 int *last_note_ptr;
	 phrase_c *phrase_ptr;
};


#endif
