/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	cdcnos_ascii
#include <stdio.h>
#include "common.h"

/* Previous obsolete lex code:

@A			{ output ('@'); }
@B			{ output ('^'); }
@D			{ output (':'); }
@G			{ output ('`'); }

\^\040			{ output ('\015'); }
\^!			{ output ('\026'); }
\^\"			{ output ('\024'); }
\^#			{ output ('\020'); }
\^$			{ output ('\013'); }
\^\%			{ output ('\023'); }
\^&			{ output ('\027'); }
\^'			{ output ('\030'); }
\^\(			{ output ('\011'); }
\^\)			{ output ('\012'); }
\^\*			{ output ('\007'); }
\^\+			{ output ('\005'); }
\^\,			{ output ('\016'); }
\^-			{ output ('\006'); }
\^\.			{ output ('\017'); }
\^\/			{ output ('\010'); }

\^0			{ output ('{'); }
\^1			{ output ('|'); }
\^2			{ output ('}'); }
\^3			{ output ('~'); }
\^4			{ output ('\177'); }

\^5			{ output ('\000'); }
\^6			{ output ('\001'); }
\^7			{ output ('\002'); }
\^8			{ output ('\003'); }
\^9			{ output ('\004'); }

\^;			{ output ('\037'); }
\^<			{ output ('\032'); }
\^=			{ output ('\014'); }
\^>			{ output ('\033'); }
\^?			{ output ('\031'); }
\^@			{ output ('\034'); }

\^[A-Z]			{ output (yytext[1]-'A'+'a'); }

\^\[			{ output ('\021'); }
\^\\			{ output ('\035'); }
\^]			{ output ('\022'); }
\^\^			{ output ('\036'); }
\^_			{ output ('\025'); }

\^[a-z]			{ output (yytext[1]); }

*/

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */

  while ((input_char = getc (input_file)) != EOF)
    {
      switch (input_char)
	{
        case '@':
	  switch ((input_char = getc (input_file)))
	    {
	    case 'A': case 'a': input_char = '@'; break;
	    case 'B': case 'b': input_char = '^'; break;
	    case 'D': case 'd': input_char = ':'; break;
	    case 'G': case 'g': input_char = '`'; break;

	    default:
	      putc ('@', output_file);
	      if (input_char == EOF)
		return;
	    }
	  break;

	case '^':
	  input_char = getc (input_file);
	  if (input_char >= 'A' && input_char <= 'Z')
	    input_char += 'a' - 'A';
	  else if (input_char < 'a' || input_char > 'z')
	    switch (input_char)
	      {
	      case ' ': input_char = '\015'; break;
	      case '!': input_char = '\026'; break;
	      case '"': input_char = '\024'; break;
	      case '#': input_char = '\020'; break;
	      case '$': input_char = '\013'; break;
	      case '%': input_char = '\023'; break;
	      case '&': input_char = '\027'; break;
	      case '\'': input_char = '\030'; break;
	      case '(': input_char = '\011'; break;
	      case ')': input_char = '\012'; break;
	      case '*': input_char = '\007'; break;
	      case '+': input_char = '\005'; break;
	      case ',': input_char = '\016'; break;
	      case '-': input_char = '\006'; break;
	      case '.': input_char = '\017'; break;
	      case '/': input_char = '\010'; break;
	      case '0': input_char = '{'; break;
	      case '1': input_char = '|'; break;
	      case '2': input_char = '}'; break;
	      case '3': input_char = '~'; break;
	      case '4': input_char = '\177'; break;
	      case '5': input_char = '\000'; break;
	      case '6': input_char = '\001'; break;
	      case '7': input_char = '\002'; break;
	      case '8': input_char = '\003'; break;
	      case '9': input_char = '\004'; break;
	      case ';': input_char = '\037'; break;
	      case '<': input_char = '\032'; break;
	      case '=': input_char = '\014'; break;
	      case '>': input_char = '\033'; break;
	      case '?': input_char = '\031'; break;
	      case '@': input_char = '\034'; break;
	      case '[': input_char = '\021'; break;
	      case '\\': input_char = '\035'; break;
	      case ']': input_char = '\022'; break;
	      case '^': input_char = '\036'; break;
	      case '_': input_char = '\025'; break;

	      default:
	        putc ('^', output_file);
	        if (input_char == EOF)
		  return;
	      }
	  break;
	}
      putc (input_char, output_file);
    }
}
