/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	bangbang_latin1
#include <stdio.h>
#include "common.h"

/* Previous obsolete lex code:

[A-Z]			{ output (yytext[0]-'A'+'a'); }

!\"			{ output ('!'); }

!0			{ output ('\340'); /+ a` +/ }
!1			{ output ('\342'); /+ a^ +/ }
!2			{ output ('\351'); /+ e' +/ }
!3			{ output ('\350'); /+ e` +/ }
!4			{ output ('\353'); /+ e" +/ }
!5			{ output ('\352'); /+ e^ +/ }
!6			{ output ('\354'); /+ e" +/ }
!7			{ output ('\356'); /+ i^ +/ }
!8			{ output ('\364'); /+ o^ +/ }
!9			{ output ('\371'); /+ u` +/ }
!:			{ output ('\373'); /+ u^ +/ }

!=			{ output ('\347'); /+ c, +/ }
!>			{ output ('\253'); /+ `` +/ }
!\?			{ output ('\273'); /+ '' +/ }

!@			{ output ('`'); }

![A-Z]			{ output (yytext[1]); }

!\[			{ output ('{'); }
!\\			{ output ('|'); }
!]			{ output ('}'); }
!^			{ output ('~'); }

!_			{ output ('\177'); }

![a-z]			{ output (yytext[1]-'a'+'A'); }

!!@			{ output ('\000'); }

!![A-Z]			{ output (yytext[2]-'A'+1); }

!!\[			{ output ('\033'); }
!!\\			{ output ('\034'); }
!!]			{ output ('\035'); }
!!^			{ output ('\036'); }
!!_			{ output ('\037'); }

!![a-z]			{ output (yytext[2]-'a'+1); }

*/

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */

  while ((input_char = getc (input_file)) != EOF)
    {
      if (input_char >= 'A' && input_char <= 'Z')
        input_char += 'a' - 'A';
      else if (input_char == '!')
	{
	  input_char = getc (input_file);
	  if (input_char >= 'a' && input_char <= 'z')
	    input_char += 'A' - 'a';
	  else if (input_char < 'A' || input_char > 'Z')
	    switch (input_char)
	      {
	      case '"': input_char = '!'; break;
	      case '0': input_char = '\340'; break; /* a` */
	      case '1': input_char = '\342'; break; /* a^ */
	      case '2': input_char = '\351'; break; /* e' */
	      case '3': input_char = '\350'; break; /* e` */
	      case '4': input_char = '\353'; break; /* e" */
	      case '5': input_char = '\352'; break; /* e^ */
	      case '6': input_char = '\354'; break; /* e" */
	      case '7': input_char = '\356'; break; /* i^ */
	      case '8': input_char = '\364'; break; /* o^ */
	      case '9': input_char = '\371'; break; /* u` */
	      case ':': input_char = '\373'; break; /* u^ */
	      case '=': input_char = '\347'; break; /* c, */
	      case '>': input_char = '\253'; break; /* `` */
	      case '?': input_char = '\273'; break; /* '' */
	      case '@': input_char = '`'; break;
	      case '[': input_char = '{'; break;
	      case '\\': input_char = '|'; break;
	      case ']': input_char = '}'; break;
	      case '^': input_char = '~'; break;
	      case '_': input_char = '\177'; break; /* del */

	      case '!':
	        input_char = getc (input_file);
		if (input_char >= 'A' && input_char <= 'Z')
		  input_char += 1 - 'A';
	        else if (input_char >= 'a' && input_char <= 'z')
		  input_char += 1 - 'a';
	        else
		  switch (input_char)
		    {
		    case '@': input_char = '\000'; break;
		    case '[': input_char = '\033'; break;
		    case '\\': input_char = '\034'; break;
		    case ']': input_char = '\035'; break;
		    case '^': input_char = '\036'; break;
		    case '_': input_char = '\037'; break;

		    default:
		      putc ('!', output_file);
		      putc ('!', output_file);
		      if (input_char == EOF)
		        return;
		    }
		break;

	      default:
	        putc ('!', output_file);
	        if (input_char == EOF)
		  return;
	      }
	}
      putc (input_char, output_file);
    }
}
