/* sys/waitpid.c (emx+gcc) -- Copyright (c) 1993 by Eberhard Mattes */

#define INCL_DOSPROCESS

#include <sys/emx.h>
#include <os2emx.h>
#include "syscalls.h"
#include <stdio.h>

#if defined(__DEBUG__)
extern FILE		*debugFile;
#define DEBUG_OUT writeDebugInfo
#else
#define DEBUG_OUT
#endif

int __waitpid (int pid, int *status, int options)
{
  ULONG rc;
  RESULTCODES res;
  PID pid2;
int		myPid;

#if defined(__DEBUG__)
myPid = getpid();
DEBUG_OUT("waitpid: myPid=%d, pid=%d\n", myPid, pid);
#endif
if(pid == -1)
	pid = 0;
  rc = DosWaitChild (DCWA_PROCESS, DCWW_WAIT, &res, &pid2, pid);
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return (-1);
    }
  *status = res.codeResult << 8;
  return (pid);
}
