#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#if defined(__BORLANDC__)
#define INCL_DOSMISC
#include <os2def.h>
#include <bsedos.h>
#else
#include <os2emx.h>
#endif
#include <string.h>
#include <ctype.h>

typedef short bool;

int		findDoubleZero(char*);
static int	findFile(char*, char**, char**);

/* accept a file name and find an executable file based on the name
   according to the methods of SVR4
+*/

char*		/*	absolute path of .exe file - with arguments
				if the original file is a shell script
			*/
	findExecutable(char *file,
				   int *startAppendOffset	/*	input file is shell - prepend
										this many characters to original list */
					)
{
int		i,
		recurse,		/* control recursion (well-almost) */
		result;
bool	appendEXE;
char		*baseFile,
			*localFile,
			*path,
			*pch1,
			*shell,
			*scriptFile,
			*string1;
		
#define LOOKING_FOR_EXE		1
#define WAS_SCRIPT 4
#define EXE_WAS_APPENDED 010

recurse = 0;
string1 = NULL;
shell = NULL;
localFile = file;
scriptFile = NULL;

l4:

/* Find the last directory seperator character in the file name */
for(baseFile=localFile, pch1=localFile;	*pch1!=0;	++pch1)
	if( (*pch1=='/') || (*pch1=='\\') )
		baseFile = pch1 + 1;
appendEXE = strrchr(baseFile, '.') == NULL?	TRUE:	FALSE;
i = findFile(localFile, &shell, &path);
switch(i)
	{
case 3:						/* not executable */
	goto errReturn;
case 2:						/* executable */
	*startAppendOffset = strlen(path) + 1;
	if(recurse & WAS_SCRIPT)
		{i = findDoubleZero(scriptFile);
		path = realloc(path, *startAppendOffset+i+1);
		if(path == NULL)		
			goto errReturn;
		memcpy(path+*startAppendOffset, scriptFile, i);
		*startAppendOffset += i;
		*(path + *startAppendOffset - 1) = ' ';
		}
	if(recurse & EXE_WAS_APPENDED)		free(localFile);
	if(shell != NULL)		free(shell);
	if(scriptFile != NULL)		free(scriptFile);
	return path;
case 0:						/* not found */
	if((recurse & LOOKING_FOR_EXE) || !appendEXE)
		goto errReturn;
	recurse |= (LOOKING_FOR_EXE | EXE_WAS_APPENDED);
	string1 = localFile;
	localFile = malloc(strlen(string1)+5);
	strcpy(localFile, string1);
	if(string1 != file)		free(string1);
	strcat(localFile, ".exe");
	goto l4;
case 1:						/* executable ascii */
	if(recurse & WAS_SCRIPT)
		goto errReturn;
	recurse |= WAS_SCRIPT;
	recurse &= ~LOOKING_FOR_EXE;
	scriptFile = path;
	path = NULL;
	if(recurse & EXE_WAS_APPENDED)
		free(localFile);
	recurse &= ~EXE_WAS_APPENDED;
	localFile = shell;
	goto l4;
	
	}

errReturn:

if(recurse & EXE_WAS_APPENDED)
	free(localFile);
if(path != NULL)
	free(path);
if(shell != NULL)
	free(shell);
if(scriptFile != NULL)		free(scriptFile);
return NULL;
}


static int			/*	0=>not found, 1=>executable ascii,
				2=> probably executable, 3=>not executable */
findFile(char *name,
		char **shellName,
		char **path		/* put absolute path here */
		)

{
#define READ_COUNT 200
bool		absPath;
int			charsRead,
			handle,
			i,
			pathLength,
			retVal;
unsigned char fileData[READ_COUNT+1];
unsigned char		*pch,
			*pch2;

retVal = 0;
*path = NULL;
*shellName = NULL;
absPath = FALSE;
for(pch=name;	*pch;	++pch)
	{if(*pch=='/' || *pch=='\\')
		{absPath = TRUE;
		break;
		}
	}
if(absPath)
	{*path = malloc(strlen(name)+2);
	strcpy(*path, name);
	}
else
	{handle = -1;
	*path = malloc(260);
	if(*path == NULL)
		goto errReturn;
	if(DosSearchPath(SEARCH_ENVIRONMENT|SEARCH_CUR_DIRECTORY, "PATH", name,
			*path, 256))
		goto errReturn;
	}
i = strlen(*path);
*(*path+i+1) = 0;
handle = open(*path, O_RDONLY | O_TEXT);
if(handle < 0)
	goto errReturn;
charsRead = read(handle, (void *)fileData, READ_COUNT);
close(handle);
if(charsRead <= 0)
	goto errReturn;
fileData[charsRead] = 0;
for(i=0, pch=fileData;	i<charsRead;	++i, ++pch)
	if(!isascii(*pch) || (!isprint(*pch)&&(*pch!='\n')&&(*pch!='\t')))
		return 2;
/* file data appears to be ASCII.  See if it is legal format for shell script */
if( (*fileData!='#') ||(*(fileData+1)!='!') )
	return 3;
for(i=2, pch=fileData+2;	i<charsRead;	++i, ++pch) /* ship whitespace */
	if( !isspace(*pch) )
		goto l4;
retVal = 3;
goto errReturn;

l4:

pathLength = strlen(*path);
*path = realloc(*path, pathLength+charsRead+3);
*shellName = malloc(charsRead);
for(pch2=*shellName, i=pch-fileData;  !isspace(*pch) && i<charsRead;	++i)
	*pch2++ = *pch++;
*pch2++ = 0;
*pch = 0;
/* skip white space then append any characters after the shell name to
   the name of the script file */
for(	;isspace(*pch)&&i<charsRead;	++i)
	++pch;
if(*pch == '\n')
	return 1;
for(pch2=*path+pathLength+1;	!isspace(*pch)&&i<charsRead&&*pch!='\n';	++i)
	*pch2++ = *pch++;
*pch2++ = 0;
*pch2 = 0;
return 1;

errReturn:

if(*path != NULL)
	{free(*path);
	*path = NULL;
	}
if(*shellName != NULL)
	{free(*shellName);
	*shellName = NULL;
	}
return retVal;
}

int			/* offset of second zero in a 2-zero sequence */
findDoubleZero(char *str)
{int		i;
char		*pch;

for(i=0, pch=str;	;++i, ++pch)
	if(!*pch)
		if(!*(pch+1))
			return i+1;
}


#if 0					/* test of basic findExecutable functionality */
main(int argc, char **argv)
{char	name[200],
		*pch,
		**pch2;
int		charsInPath,
		i;

l2:

printf("Enter file name:");
for(pch=name;	;++pch)
	{*pch = getchar();
	if(*pch== '\n')
		break;
	}
*pch = 0;
pch = findExecutable(name, &i);
free(pch);
goto l2;
}
#endif

#if 0
main(int argc,	char **argv)

{char *array[] = 	{" ", "arg1", "arg2"};
char *const *args=array;

execv("tst_args", args);
}

void _sys_set_errno(int	rc)
{return;
}
#endif
