/* times.c, created from times.def. */
#line 23 "(null)times.def"

#line 30 "(null)times.def"

#include "../shell.h"
#include <sys/types.h>
#include <stdio.h>					/* 2/93 ROB */
#if defined (hpux) || defined (USGr4) || defined (XD88)
#  undef HAVE_RESOURCE
#endif /* hpux || USGr || XD88 */

#if defined (HAVE_RESOURCE)
#  include <sys/time.h>
#  include <sys/resource.h>
#else /* !HAVE_RESOURCE */
#  include <sys/times.h>
#endif /* !HAVE_RESOURCE */

/* Print the totals for system and user time used.  The
   information comes from variables in jobs.c used to keep
   track of this stuff. */
times_builtin (list)
     WORD_LIST *list;
{
#if defined (HAVE_RESOURCE) && defined (RUSAGE_SELF)
  struct rusage self, kids;

  no_args (list);

  getrusage (RUSAGE_SELF, &self);
  getrusage (RUSAGE_CHILDREN, &kids);	/* terminated child processes */

  print_timeval (&self.ru_utime);
  putchar (' ');
  print_timeval (&self.ru_stime);
  putchar ('\n');
  print_timeval (&kids.ru_utime);
  putchar (' ');
  print_timeval (&kids.ru_stime);
  putchar ('\n');

#else /* !HAVE_RESOURCE || !RUSAGE_SELF */
#  if !defined (BrainDeath)
  struct tms t;

  no_args (list);

  times (&t);

  /* As of System V.3, HP-UX 6.5, and other ATT-like systems, this stuff is
     returned in terms of clock ticks (HZ from sys/param.h).  C'mon, guys.
     This kind of stupid clock-dependent stuff is exactly the reason 4.2BSD
     introduced the `timeval' struct. */

  print_time_in_hz (t.tms_utime);
  putchar (' ');
  print_time_in_hz (t.tms_stime);
  putchar ('\n');
  print_time_in_hz (t.tms_cutime);
  putchar (' ');
  print_time_in_hz (t.tms_cstime);
  putchar ('\n');
#  endif /* BrainDeath */
#endif /* !HAVE_RESOURCE || !RUSAGE_SELF */

  return (EXECUTION_SUCCESS);
}
