/* suspend.c, created from suspend.def. */
#line 23 "(null)suspend.def"

#line 32 "(null)suspend.def"

#include <signal.h>
#include <sys/types.h>
#include "../shell.h"
#include "../jobs.h"

#if defined (JOB_CONTROL)
extern int job_control;

static SigHandler *old_cont, *old_tstp;

/* Continue handler. */
sighandler
suspend_continue (sig)
     int sig;
{
#if defined (__EMX__)				/* 2/93 ROB */
return;
#else
  signal (SIGCONT, old_cont);
  signal (SIGTSTP, old_tstp);
#endif
}

/* Suspending the shell.  If -f is the arg, then do the suspend
   no matter what.  Otherwise, complain if a login shell. */
int
suspend_builtin (list)
     WORD_LIST *list;
{
  if (!job_control)
    {
      builtin_error ("Cannot suspend a shell without job control");
      return (EXECUTION_FAILURE);
    }

  if (list)
    if (strcmp (list->word->word, "-f") == 0)
      goto do_suspend;

  no_args (list);

  if (login_shell)
    {
      builtin_error ("Can't suspend a login shell");
      return (EXECUTION_FAILURE);
    }

do_suspend:

#if !defined(__EMX__)						/* 2/93 ROB */
  old_cont = (SigHandler *)signal (SIGCONT, suspend_continue);
  old_tstp = (SigHandler *)signal (SIGTSTP, SIG_DFL);
  killpg (shell_pgrp, SIGTSTP);
#endif
  return (EXECUTION_SUCCESS);
}

#endif /* JOB_CONTROL */
