/* fg_bg.c, created from fg_bg.def. */
#line 23 "(null)fg_bg.def"

#line 32 "(null)fg_bg.def"

#include <sys/types.h>
#include <signal.h>
#include "../shell.h"
#include "../jobs.h"

extern int job_control;
static int fg_bg ();

/* How to bring a job into the foreground. */
int
fg_builtin (list)
     WORD_LIST *list;
{
  int fg_bit = 1;
  register WORD_LIST *t = list;

  if (!job_control)
    return (EXECUTION_SUCCESS);

  /* If the last arg on the line is '&', then start this job in the
     background.  Else, fg the job. */

  while (t && t->next)
    t = t->next;

  if (t && strcmp (t->word->word, "&") == 0)
    fg_bit = 0;

  return (fg_bg (list, fg_bit));
}

#line 72 "(null)fg_bg.def"

/* How to put a job into the background. */
int
bg_builtin (list)
     WORD_LIST *list;
{
  if (!job_control)
    return (EXECUTION_SUCCESS);

  return (fg_bg (list, 0));
}

/* How to put a job into the foreground/background. */
static int
fg_bg (list, foreground)
     WORD_LIST *list;
     int foreground;
{
  extern char *this_command_name;
  sigset_t set, oset;
  int job, status = EXECUTION_SUCCESS;

  BLOCK_CHILD (set, oset);
  job = get_job_spec (list);

  if (job < 0 || job >= job_slots || !jobs[job])
    {
      if (job != DUP_JOB)
	builtin_error ("No such job %s", list ? list->word->word : "");

      goto failure;
    }

  /* Or if jobs[job]->pgrp == shell_pgrp. */
  if (jobs[job]->job_control == 0)
    {
      builtin_error ("job %%%d started without job control", job + 1);
      goto failure;
    }

  status = start_job (job, foreground);
  if (status >= 0)
    {
    /* win: */
      UNBLOCK_CHILD (oset);
      return (status);
    }
  else
    {
    failure:
      UNBLOCK_CHILD (oset);
      return (EXECUTION_FAILURE);
    }
}

