/* enable.c, created from enable.def. */
#line 23 "(null)enable.def"

#line 33 "(null)enable.def"

#include "../shell.h"
#include "../builtins.h"

static int enable_shell_command ();

/* Enable/disable shell commands present in LIST.  If list is not specified,
   then print out a list of shell commands showing which are enabled and
   which are disabled. */
enable_builtin (list)
     WORD_LIST *list;
{
  int result = 0, any_failed = 0;

  if (!list)
    {
      register int i;

      for (i = 0; i < num_shell_builtins; i++)
	{
	  if (!shell_builtins[i].function)
	    continue;

	  printf ("enable %s%s\n", shell_builtins[i].enabled ? "" : "-n ",
		  shell_builtins[i].name);
	}
    }
  else
    {
      int disable_p = (strcmp (list->word->word, "-n") == 0);

      if (disable_p)
	list = list->next;

      while (list)
	{
	  result = enable_shell_command (list->word->word, disable_p);
	  if (!result)
	    {
	      builtin_error ("%s: not a shell builtin", list->word->word);
	      any_failed++;
	    }
	  list = list->next;
	}
    }
  return (any_failed ? EXECUTION_FAILURE : EXECUTION_SUCCESS);
}

/* Enable the shell command NAME.  If DISABLE_P is non-zero, then
   disable NAME instead. */
static int
enable_shell_command (name, disable_p)
     char *name;
     int disable_p;
{
  register int i;
  int found = 0;

  for (i = 0; i < num_shell_builtins; i++)
    {
      if (!shell_builtins[i].function)
	continue;

      if (strcmp (name, shell_builtins[i].name) == 0)
	{
	  found++;
	  shell_builtins[i].enabled = !disable_p;
	}
    }
  return (found);
}
