////////////////////////////////////////////////////////////////////////////////
//
//                    FileBar - Maximize/Movement Hook DLL
//
//         OS/2 Application Launch Facility and WPS Shell Replacement
//
//                         Written By Eric A. Wolf
//                 Copyright (C) 1994 - All Rights Reserved
//
// This source code may be used for reference ONLY!  It is provided AS-IS and no
// guarantees are made as to its utility, functionality or correctness.  It is
// provided solely as a guide to aid aspiring OS/2 2.x Presentation Manager
// programmers in developing their own PM applications.  No modifications are
// to be made to this code for re-release as a same or different product.  This
// code must be distributed (in its original entirety) with the executable
// portion of this product.
//
//          -- Please register this shareware product for $10 today --
//                          See documentation for details
//
// DLL Project Start Date:      March  5, 1994
// DLL Project Completion Date: March  6, 1994
//
// Written using Borland C++ for OS/2, version 1.0
//
// File Last Modified:          April  5, 1994
//
////////////////////////////////////////////////////////////////////////////////
#define INCL_PMWIN
#define INCL_WINSYS
#define INCL_WIN
#define INCL_PM
#define INCL_WINFRAMEMGR
#define DLL_NAME                 "FILEBAR"        // define the name for our DLL
#define POPUPMENU                9999             // msg to send to signal popup

#include <string.h>
#include <stdio.h>
#include "filebar.h"


//------------------------------------------------------------------------------
// define data we need for our DLL
//------------------------------------------------------------------------------
LONG  messageID;                                  // message to popup our menu
SHORT ScreenY;                                    // height of menubar
SHORT ScreenHeight;                               // useful screen remaining
CHAR  tmp[18];                                    // buffer to hold session titles
BOOL  BarAtTop;                                   // is the menubar at the top
BOOL  intercept;                                  // should we intercept msgs?
BOOL  popUpMenu;                                  // allow popup menu?
HWND  hwndApp;                                    // store handle of app window
HMODULE hmModule;                                 // store module data for app


//------------------------------------------------------------------------------
// setFileBarScreen - sets internal position and size data our DLL needs to
// correctly set the maximize screen data
//------------------------------------------------------------------------------
VOID EXPENTRY setFileBarScreen( BOOL position, LONG y, BOOL interceptMsgs, BOOL popUp, LONG msgID )
{
    messageID = msgID;
    intercept = interceptMsgs;
    popUpMenu = popUp;
    BarAtTop  = position;
    ScreenY   = y;
    ScreenHeight = WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN ) - y;
}


//------------------------------------------------------------------------------
// Handle all input messages - search for WM_CHORD
//------------------------------------------------------------------------------
BOOL EXPENTRY FileBarInputHook(HAB habAnchor,PQMSG pqmMsg,ULONG ulFlags)
{
    //--------------------------------------------------------------------------
    // if any window is moved, make sare FileBar is placed on top of it
    //--------------------------------------------------------------------------
    if ((pqmMsg->msg == messageID) && (popUpMenu))
        return WinPostMsg( hwndApp, WM_COMMAND, MPFROMLONG(POPUPMENU), MPFROMLONG(pqmMsg->hwnd) );
    return FALSE;
}


//------------------------------------------------------------------------------
// FileBarHook - this is called whenever a message is sent in the system.  So,
// we simply look at each message going by and if it's something dealing with
// moving or maximizing, intercept and alter so that FileBar is always on top
// and no maximizing covers it!
//
// Note:  The parameters sent to FileBarHook are defined in the SendMsg Hook
//
// Returns:  TRUE if the rest of the hook chain is not to be called, or FALSE
//           if the rest of the hook chain should be called.
//------------------------------------------------------------------------------
BOOL EXPENTRY FileBarHook(HAB habAnchor,PSMHSTRUCT structurePtr,BOOL interTask)
{
    if (!intercept)
        return FALSE;

    switch(structurePtr->msg) {
        //----------------------------------------------------------------------
        // if any window is moved, make sare FileBar is placed on top of it
        //----------------------------------------------------------------------
        case WM_MOVE:
            return WinSetWindowPos( hwndApp, HWND_TOP,0,0,0,0,SWP_ZORDER);
        //----------------------------------------------------------------------
        // if a window is being maximized, make it fit below or on top of the
        // FileBar application window
        //----------------------------------------------------------------------
        case WM_WINDOWPOSCHANGED: {
          // the way BocaSoft's WipeOut screen saver is designed, when it is
          // running, FileBar is still visible.  So, when that screen saver is
          // requesting a maximized screen, give it access to the full screen
          WinQuerySessionTitle( habAnchor, 0, tmp, sizeof(tmp) );
          if (strcmp( tmp, "BocaSoft WipeOut") == 0)
              return FALSE;

          if (LONGFROMMP(structurePtr->mp2) & AWP_MAXIMIZED) {
            PSWP pSwp = (PSWP)LONGFROMMP(structurePtr->mp1);
            if ((pSwp->x>60000) && (pSwp->y>60000)) {
                SHORT xBorder = WinQuerySysValue( HWND_DESKTOP, SV_CXSIZEBORDER );
                SHORT yBorder = WinQuerySysValue( HWND_DESKTOP, SV_CYSIZEBORDER );
                pSwp->x = 0 - xBorder;
                pSwp->cx = WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN ) + 2*xBorder;
                if ( !BarAtTop ) {
                    pSwp->y = ScreenY - yBorder - 1;
                    pSwp->cy = ScreenHeight + 2*yBorder + 1;
                    }
                else {
                    pSwp->y = 0 - yBorder;
                    pSwp->cy = ScreenHeight + 2*yBorder;
                    }
                return WinSetWindowPos( structurePtr->hwnd, 0, pSwp->x, pSwp->y, pSwp->cx, pSwp->cy, SWP_MOVE|SWP_SIZE);
                }

            }
          }
        //----------------------------------------------------------------------
        // if it is nothing we care about, pass it onto the system
        //----------------------------------------------------------------------
        default:
            break;
        }
    return FALSE;
}


//------------------------------------------------------------------------------
// FileBarInit - initialize FileBar DLL.  This will load in the DLL, store the
// handle to the module and set the system hook so that we intercept messages
//
// Returns:  TRUE if successful, FALSE otherwise
//------------------------------------------------------------------------------
BOOL EXPENTRY FileBarInit( HWND hwnd )
{
   hwndApp = hwnd;

   if (DosQueryModuleHandle(DLL_NAME,&hmModule))
      return FALSE;

   //WinBroadcastMsg(HWND_DESKTOP,WM_NULL,0,0,BMSG_FRAMEONLY|BMSG_POST);
   WinSetHook(WinQueryAnchorBlock(hwndApp),
              NULLHANDLE,
              HK_SENDMSG,
              (PFN)FileBarHook,
              hmModule);
   //WinBroadcastMsg(HWND_DESKTOP,WM_NULL,0,0,BMSG_FRAMEONLY|BMSG_POST);
   WinSetHook(WinQueryAnchorBlock(hwndApp),
              NULLHANDLE,
              HK_INPUT,
              (PFN)FileBarInputHook,
              hmModule);
   return WinBroadcastMsg(HWND_DESKTOP,WM_NULL,0,0,BMSG_FRAMEONLY|BMSG_POST);
}


//-------------------------------------------------------------------------
// FileBarQuit - this releases the FileBar DLL
// Returns:  TRUE always
//-------------------------------------------------------------------------
BOOL EXPENTRY FileBarQuit( VOID )
{
   WinReleaseHook(WinQueryAnchorBlock(hwndApp),
                  NULLHANDLE,
                  HK_SENDMSG,
                  (PFN)FileBarHook,
                  hmModule);
   //WinBroadcastMsg(HWND_DESKTOP,WM_NULL,0,0,BMSG_FRAMEONLY|BMSG_POST);
   WinReleaseHook(WinQueryAnchorBlock(hwndApp),
                  NULLHANDLE,
                  HK_INPUT,
                  (PFN)FileBarInputHook,
                  hmModule);
   return WinBroadcastMsg(HWND_DESKTOP,WM_NULL,0,0,BMSG_FRAMEONLY|BMSG_POST);
}

