/*------------------------------------------------------------------
 * roxapi.h : C programming interface to Rox
 *------------------------------------------------------------------
 * 09-02-93 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

#if !defined(__ROXAPI_H_DEFINED__)
#define __ROXAPI_H_DEFINED__

/*------------------------------------------------------------------
 * typedef of REXX function handler
 *------------------------------------------------------------------*/
#if defined(OPSYS_AIX)
   typedef ULONG RexxFunctionHandler(PUCHAR,
                                     ULONG,
                                     PRXSTRING,
                                     PSZ,
                                     PRXSTRING);
#endif

/*------------------------------------------------------------------
 * rexx functions
 *------------------------------------------------------------------*/
RexxFunctionHandler RoxLoadFuncs;
RexxFunctionHandler RoxDropFuncs;
RexxFunctionHandler RoxVersion;

RexxFunctionHandler RoxQueryClassLoaded;
RexxFunctionHandler RoxAddClass;
RexxFunctionHandler RoxClassAddInherit;
RexxFunctionHandler RoxClassAddMethod;
RexxFunctionHandler RoxClassAddMethodDll;
RexxFunctionHandler RoxClassAddVar;
RexxFunctionHandler RoxLoadDll;

RexxFunctionHandler RoxCreate;
RexxFunctionHandler RoxDestroy;
RexxFunctionHandler RoxSend;
RexxFunctionHandler RoxSendThread;
RexxFunctionHandler RoxSendByFunction;
RexxFunctionHandler RoxClass;
RexxFunctionHandler RoxAddVar;
RexxFunctionHandler RoxDump;
RexxFunctionHandler RoxStats;

/*------------------------------------------------------------------
 * typedef for function that handles method invocation
 *------------------------------------------------------------------*/
typedef ULONG APIENTRY RoxMethodHandlerType(
   void      *object,
   PUCHAR     name,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   );

/*------------------------------------------------------------------
 * typedef for DLL entrypoint function named "RoxDllEntryPoint"
 *------------------------------------------------------------------*/
typedef ULONG APIENTRY RoxDllEntryPointType(
   ULONG init
   );

/*------------------------------------------------------------------
 * prototypes of utility functions
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxVariableGet(
   void      *object,
   PRXSTRING  name,
   PRXSTRING  value
   );

ULONG APIENTRY RoxVariableSet(
   void      *object,
   PRXSTRING  name,
   PRXSTRING  value
   );

/*------------------------------------------------------------------
 * platform independent function to allocate 'system' memory
 *------------------------------------------------------------------*/
void * APIENTRY osMalloc(
   int size
   );

/*------------------------------------------------------------------
 * platform independent function to free 'system' memory
 *------------------------------------------------------------------*/
void APIENTRY osFree(
   void *ptr
   );

#endif
