#define INCL_ERRORS
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PROGNAME "server"
#define PIPE_NAME "\\pipe\\sembatch\\server"
#define MESSAGE_SIZE 128
#define BUF_SIZE 1024

typedef char *pchar, **ppchar;

void error_check(char *string,int i) {
	if (i) {
		printf ("Error %d!!!\n%s\n",i,string);
		exit(-1);
	}
}

void main (void) {
	HPIPE hpHandle;
	CHAR pszInBuf[MESSAGE_SIZE],pszOutBuf[MESSAGE_SIZE];
	ULONG ulBytes;
	USHORT rc;
	
	setbuf(stdout,NULL);
	rc=DosCreateNPipe(PIPE_NAME,
					  &hpHandle,
					  NP_ACCESS_DUPLEX | NP_NOWRITEBEHIND,
					  NP_WAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 1,
					  BUF_SIZE,
					  BUF_SIZE,
					  0);
	error_check("DosCreateNPipe",rc);
	while (1) {
		rc=DosConnectNPipe(hpHandle);
		error_check("DosConnectNPipe",rc);

		rc=DosRead(hpHandle,pszInBuf,MESSAGE_SIZE,&ulBytes);
		error_check("DosRead",rc);
		
		printf("read:%s\n",pszInBuf);
		strcpy(pszOutBuf,pszInBuf);
		
		rc=DosWrite(hpHandle,pszOutBuf,MESSAGE_SIZE,&ulBytes);
		error_check("DosWrite",rc);
		printf("wrote:%s\n",pszOutBuf);

/*		rc=DosResetBuffer(hpHandle);
		if (rc!=ERROR_BROKEN_PIPE)
			error_check("DosResetBuffer",rc);
*/
		rc=DosRead(hpHandle,pszOutBuf,1,&ulBytes);
		if (ulBytes!=0) error_check("DosRead:EOF check",rc);
		
		rc=DosDisConnectNPipe(hpHandle);
		error_check("DosDisConnectNPipe",rc);
	}
}
