/* _fdinit.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <emx/io.h>

/* See app/iodata.c. */

extern int _nfiles;
extern int _files[];
extern int _lookahead[];

/* Return pointer to flags word for the new file descriptor HANDLE and
   initialize lookahead.  Return NULL on error. */

int *_fd_init (int handle)
{
  struct fdvec *p, *last;
  int i, n;

  if (handle < 0)
    return NULL;

  p = &_fdvec_head; last = NULL;
  while (p != NULL && handle >= p->n)
    {
      handle -= p->n;
      last = p;
      p = p->next;
    }
  if (p == NULL)
    {
      n = handle + 1;
      if (n < 32) n = 32;

      p = malloc (sizeof (*p));
      if (p == NULL)
        return NULL;
      p->flags = malloc (n * sizeof (int));
      if (p->flags == NULL)
        {
          free (p);
          return NULL;
        }
      p->lookahead = malloc (n * sizeof (int));
      if (p->lookahead == NULL)
        {
          free (p->flags);
          free (p);
          return NULL;
        }
      for (i = 0; i < n; ++i)
        {
          p->flags[i] = 0;
          p->lookahead[i] = -1;
        }
      p->n = n;
      p->next = NULL;
      last->next = p;
    }

  p->lookahead[handle] = -1;
  return &p->flags[handle];
}
