/*
 * hex2prn.c Begun: Tue  04-21-1992        Revised: Wed  04-22-1992
 * M. F. Kaplon    Using IBM C Set 2 vs.6.177 and Toolkit20 Vs.6.304 of OS/2 2.0
 * Send Set Up String to  Printer defined as : LPT1
 * Compile and statically link run time library as:  icc hex2prn.c
 * Compile and dynamically link run time library as: icc /Gd+ hex2prn.c
 * Dynamic link option much smaller(4K vs 23K) but loads a little slower.
*/

#pragma langlvl(mig)   /* needed to link conio.h - migration libs required */

#define INCL_BASE
#define INCL_NOPMAPI
#define INCL_DOSDEVIOCTL

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>     /* if want unbuffered Keyboard input using getch() */

ULONG DosDeviceHandle(BYTE *DevName,ULONG *OpenAction,ULONG FileSize,USHORT FileAttribute,USHORT OpenFlag,USHORT OpenMode,PEAOP2 pEABuf);
void  DosDevErr(char *fname,USHORT categ,USHORT func,ULONG msgnum);
BYTE hex2dec(BYTE *strin);  /* convert 2 char hex symbol to a BYTE */


/*
 * Global Variables for use in dosDevIOCtl calls in a more general context
 * The variables with first character p are pointers but will be declared as
 * variables or structures and an address passed
*/
ULONG   ulCategory = 5;    /* Device Category - Printer */
ULONG   ulFunction ;       /* Device Function */
BYTE    ByteParmBuf;       /* Address of Command Specific Argument BYTE */
ULONG   ulParmLengthMax;   /* Max Length in BYTEs of ParmList */
ULONG   ParmLengthInOut;   /* Address of length in BYTEs passed in Parms on Input and length returned on Output */
ULONG   ulDataLengthMax;   /* Length in BYTES of Data Area */
ULONG   DataLengthInOut;   /* Address of length in BYTEs passed in Data Area on Input and length returned on Output */
BYTE    ByteData;          /* DataBuffer to receive Byte Data */
ULONG   ulrc;              /* Return code */

int main(int argc,char **argv)
{
   ULONG   DevHandle;      /* Handle returned by DosOpen or standard device handle */
   ULONG   OpenAction;     /* filled in by call to DosDevHandle */
   USHORT  i;              /* counter for string addressing */
   BYTE    PrnString[96];  /* 290/3 = 96.6 set up string to printer */
   ULONG   BytesWritten;


   system("cls");          /* clear screen */

   if (argc == 1)  {       /* no command line arguments passed */
       DosBeep(500,500);
       printf("\n This program passes printer codes to the printer - it is called as:");
       printf("\n Hex2prn ?? ?? ?? ............ where the ?? are separated by a space.");
       printf("\n Each ?? represents(in Hex format) a one byte component of a printer command ");
       printf("\n If only one symbol is needed it should be prefixed with a 0.");
       printf("\n Up to a total of 96 2-Character Hex combinations may be passed.");
       exit(1);
   }

   for (i=1;i<=argc-1;i++)  {  /* go thru the arguments passed */
       strupr(argv[i]);        /* convert each to upper case */
       if ( strlen(argv[i]) != 2)  {
            DosBeep(500,500);
            printf("\nData should be passed as two char Hex sequences, space separated\n");
            exit(1);
       }
       if (!( (*argv[i] >= '0' && *argv[i] <= '9') || (*argv[i] >= 'A' && *argv[i] <= 'F'))) {
            DosBeep(500,500);
            printf("\nIncorrect parameter passed");
            exit(1);
       }
       if (!(( *(argv[i]+1) >= '0' && *(argv[i]+1) <= '9') || (*(argv[i]+1) >= 'A' && *(argv[i]+1) <= 'F'))) {
            DosBeep(500,500);
            printf("\nIncorrect parameter passed");
            exit(1);
       }
       PrnString[i-1] = hex2dec(argv[i]);    /* convert to byte array */
   }

   /*  get device handle for printer */
   DevHandle = DosDeviceHandle("LPT1",&OpenAction,0,0,0x11,0x42,NULL);

   /* parms for Category 5 - Function 66H Return Printer Status */
   ulFunction       = 0x66;  /* 10010000 = 0x90 is Not Busy and Printer Selected */
   ulParmLengthMax  = 1;
   ParmLengthInOut  = 1;
   ulDataLengthMax  = 1 ;
   DataLengthInOut  = 0;
   ByteParmBuf = 0;

   while (1) {
       if ( (ulrc=DosDevIOCtl(DevHandle,ulCategory,ulFunction,&ByteParmBuf,
                          ulParmLengthMax,&ParmLengthInOut,&ByteData,
                          ulDataLengthMax, &DataLengthInOut)) != 0 )
            DosDevErr("DosDevIOCtl",ulCategory,ulFunction,ulrc);
       if (! (ByteData & 16) )  {
            DosBeep(500,500);
            printf("\nPrinter Not On :Press <Esc> to abort or Turn On and Press Any Other Key\n");
            if (getch() == 27)
                exit(0);
            else
              continue;
       }
       break;
   }
   if (ByteData == 0x90)  /*   printf("\nPrinter Selected and Ready");  */
       ;
   else {
       printf("\nPrinter not ready - Aborting");
       exit(1);
   }
   DosWrite(DevHandle,PrnString,(ULONG)(argc - 1),&BytesWritten);
/*   printf("\nBytes Written = %lu",BytesWritten);  */

   DosClose(DevHandle);

   return 0;
}

/*
 * Returns Dos Device Handle for selected device .
 * Is passed parameters for DosOpen Call
 * BYTE    PrinterId[5] ; Name as "LPT1",etc
 * ULONG   OpenAction;  ; filled in by call
 * ULONG   FileSize = 0;       for Printer
 * USHORT  FileAttribute = 0;  for Printer
 * USHORT  OpenFlag = 0x11;    for Printer
 * USHORT  OpenMode = 0x42 ;   for Printer
 * PEAOP2  pEABuf = NULL;      pointer to extended attribute structure
*/
ULONG DosDeviceHandle(BYTE *DevName,ULONG *OpenAction,ULONG FileSize,USHORT FileAttribute,USHORT OpenFlag,USHORT OpenMode,PEAOP2 pEABuf)
{
    ULONG  DeviceHandle;
    ULONG  ulrc;

    if ( (ulrc=DosOpen(DevName,&DeviceHandle,OpenAction,FileSize,FileAttribute,OpenFlag,OpenMode,pEABuf))  != 0) {
        DosDevErr("DosOpen Error - Aborting",0,0,ulrc);
        exit(1);
    }
/*    printf("\nDosOpen OK Returns : Device Handle for %s = %lu and OpenAction = %lu\n",DevName,DeviceHandle,OpenAction); */
    return DeviceHandle;
}

/*
 * Error Message for function calls non PM API
 * For non DosDevIOCtl category = function = 0
*/
void DosDevErr(char *fname,USHORT categ,USHORT func,ULONG msgnum)
{
   printf("\nAborting! %s Category %u  Function %XH  Error_# %lu",fname,categ,func,msgnum);
   printf("\n%s\n",strerror(msgnum));
   exit(1);
}

BYTE hex2dec(BYTE *strin)  /* convert 2 char hex symbol to a BYTE */
{
    BYTE   i,res=0;

    for (i=0; i <= 1; i++)  {
        if (strin[i] >= '0' && strin[i]<= '9' )  {
            if (i == 1)
                res = res + strin[i] - 48;
            else
                res = res + (strin[i] - 48)*16;
        }
        if (strin[i] >= 'A' && strin[i] <= 'F')  {
            if (i == 1)
               res = res + strin[i] - 55;
            else
               res = res + (strin[i] - 55)*16;
        }
    }
    return res;
}

