/* REXX (Really EXtraordinary eXecutor) file to install VxFTP.EXE
   Written: April 17, 1994, last revised May 26, 1994 
   Author:  Howard Hyten
 */

'@echo off'

if RxFuncQuery("SysLoadFuncs") then do
    rc = RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
    rc = SysLoadFuncs()
    if (rc = 1) then do
        say "You don't have the REXXUtil.DLL installed in your LIBPATH."
        say "You must have these components loaded before VxFTP will run."
        exit -1
    end
end
call SysCls

do forever
    say "Please enter the boot drive. [Example: C ]"
    pull bootDrive
    bootDrive = left(bootDrive, 1)
    if (datatype(bootDrive) = 'CHAR') then do
        call SysFileTree bootDrive":\config.sys", file., 'F'
        if file.1 = "FILE.1" then do
            say bootdrive "is not the Boot Drive. (Press Ctrl-Break to quit.)"
	    iterate
	end
        leave
    end /* if */
    else
        say "Wrong.."
end

do forever
    say "What is your version of IBM TCP/IP?"
    say 'Type "1"  for version 1.2.1'
    say 'Type "2"  for version 2.x'
    pull TCPVer
    select
        when TCPVer = "1" then do
            'copy rxftp.dll rxftp32.dll > nul'
            'del rxftp.dll > nul'
            'copy rxftp16.dll rxftp.dll > nul'
            leave
        end
        when TCPVer = "2" then
            leave
        otherwise
            say "You didn't properly answer."
    end
end

do forever
    line_in = linein( bootdrive':\config.sys' )
    if ( translate( left( line_in, 8)) = 'LIBPATH=' ) then
	leave
end

libpath = translate( line_in, "|", ";" )
do until rest = ""
    parse var libpath dir1 "|" rest
    if ( translate( right( dir1, 9)) = 'TCPIP\DLL') then
	leave
    libpath = rest
end
say 'Copying rxftp.dll to' dir1
'copy rxftp.dll' dir1 '> nul'
say 'Copying vrobj.dll to' bootdrive':\os2\dll'
'copy vrobj.dll' bootdrive':\os2\dll > nul'

call SysCls

say "Enter the full path of the directory where you want to install VxFTP."
say "Be sure to include the drive as well."
say "(Press return for a default of C:\VxFTP)"
parse pull target1
if ( target1 = "" ) then
    target1 = "C:\VxFTP"

call SysMkDir target1
'copy vxftp.exe' target1 '> nul'
'copy vxftp.ini' target1 '> nul'
'copy vxftp.ico' target1 '> nul'

setupString = "OBJECTID=<VxFTP>;"||,
              "EXENAME="||target1||"\vxftp.exe;"||,
              "ICONFILE="||target1||"\vxftp.ico;"||,
              "PROGTYPE=PM;"

if SysCreateObject("WPProgram", "VxFTP v0.41a", ,
                   "<WP_DESKTOP>", setupString, "R")
then do
    say "An VxFTP object was created on your Desktop."
    say "Just double-click the object to start."
end
else
    say "Couldn't create an VxFTP object on your Desktop."

say ""
say "For the Unzip feature to work, InfoZIP's Unzip"
say "must be in your PATH."

/* Bring the Readme file up into the E editor */
'start e readme'

exit 0