/* INSTALL.CMD: Install REMINDER */

'@Echo Off'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installing REMINDER for OS/2...'
Say ''


/* Verify the existence of the various component files. */

Result = SysFileTree( 'REMINDER.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: REMINDER.EXE not found!'
  Signal DONE
  End

Result = SysFileTree( 'REMINDER.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: REMINDER.DOC not found!'
  Signal DONE
  End

Result = SysFileTree( 'REMINDER.DAT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: REMINDER.DAT not found!'
  Signal DONE
  End


/* Ask for the target directory name. */

Say 'Please enter the full name of the directory to which'
Say '  you want REMINDER installed (default C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End
Say ''


/* Ask for the target folder. */

Say 'Do you wish to install to the startup folder? (Y/N)'
Pull YesNo
If YesNo = "Y" Then
  Do
  Folder = '<WP_START>'
  Say 'Object will be placed in the startup folder.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Object will be placed on the desktop.'
  End
Say ''


/* Perform the installation. */

Say 'Copying REMINDER to ' Directory '...'
Copy REMINDER.EXE Directory                  '1>NUL'
Copy REMINDER.DOC Directory                  '1>NUL'
Copy REMINDER.DAT Directory                  '1>NUL'

Say 'Creating program object...'
Type = 'WPProgram'
Title = 'Reminder for OS/2'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\REMINDER.EXE;STARTUPDIR='Directory';OBJECTID=<REMINDER>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Object created!  Done.'
Else
  Say 'ERROR: Object not created.'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
