(*Author : Michael Mrosowski*)
(*Version: 0.1*)
Program Dummy_Fossil;
{$M 4096,0,0}
{$S-}{$R-}{$I-}

uses dos,crt;

const
  Bufflen = 1000;

var
  IntTable : array[0..255] of Pointer absolute 0:0;
  Old14 : Pointer;
  SavePsp : word;
  MyPsp   : word;
  Pipe    : File;
  Signal  : File of Byte;
  OutBuffer,InBuffer : array[0..Bufflen-1] of byte;
  OutCount,InCount,result  : integer;
  OutsPerReQuest,CheckInput : integer;
  regs       : registers;
  Carrier    : Boolean;
  LastStatus : Integer;

const
  InputAvail   = $0108;
  BufferOver   = $0208;
  OutRoomAvail = $2008;
  OutBuffEmpty = $4008;
  CarrierDetect= $0088;

  MaxBuff = 10;
  CheckInputEach = 50;
  SendBack : byte = 1;
  Stopit   : byte = 2;

Function GetPsp:word;
begin
  regs.ah:=$51;
  Intr($21,regs);
  GetPsp:=regs.bx;
end;

Procedure SetPsp(newpsp:word);
begin
  regs.ah:=$50;
  regs.bx:=newpsp;
  Intr($21,regs);
end;

Procedure WriteOut; (*writes Buffer out to Pipe*)
begin
  SavePsp:=GetPsp;
  SetPsp(MyPsp);

  BlockWrite(Pipe,OutBuffer,OutCount,result);
  Dec(OutCount,Result);

  SetPsp(SavePsp);                                           
end;

Procedure ReadIn; (*Gets Data from Pipe*)
var i   : integer;
    sig : byte;
begin
  SavePsp:=GetPsp;
  SetPsp(MyPsp);

  BlockRead(Pipe,InBuffer[InCount],Bufflen-Incount,Result);
  i:=ioresult;
  if (i=0) and (Result=0) then
    Carrier:=FALSE;
  if (i<>0) and (i<>5) then
    Carrier:=FALSE;
  LastStatus:=i;

  Inc(InCount,Result);
  SetPsp(SavePsp);
end;

Function Readchar:byte; (*Waits for remote pressed key*)
begin
  if OutCount>0 then
    WriteOut;
  while (InCount=0) and (Carrier) do
    ReadIn;

  if Carrier then
  begin
    ReadChar:=InBuffer[0]; (*because only one char read max*)
    Dec(InCount);
    Move(InBuffer[1],InBuffer[0],Incount);
  end
  else ReadChar:=0;
end;

Function BuffernotEmpty:boolean;
begin
  if InCount=0 then
    if CheckInput>0 then
      Dec(CheckInput)
    else
    begin
      ReadIn;
      CheckInput:=CheckInputEach;
    end;
  BuffernotEmpty:=InCount<>0;
end;

Procedure ClosePipe;
begin
  SavePsp:=GetPsp;
  SetPsp(MyPsp);

  Close(Pipe);

  SetPsp(SavePsp);
end;

Procedure AddToOut(b:byte);
begin
  if OutCount<Bufflen then
  begin
    OutBuffer[OutCount]:=b;
    Inc(OutCount);
  end;
  If OutCount>=MaxBuff then
    WriteOut;
end;

Procedure StrOut(s:string);
var i:integer;
begin
  for i:=1 to length(s) do
    AddToOut(ord(s[i]));
end;

{For debugging only}
Procedure ScreenStr(s:string;x,y:integer;attr:byte);
var
  addr:word;
  i:integer;
begin
  addr:=(y-1)*160+(x-1)*2;
  for i:=0 to length(s)-1 do begin
    Mem[$b800:addr+i*2]:=ord(s[i+1]);
    Mem[$b800:addr+(i*2)+1]:=attr;
  end;
end;

type str10 = string[10];

Function NumStr(n,len:integer):str10;
var
  addr:word;
  i:integer;
  s:str10;
begin
  s:='';
  for i:=len downto 1 do begin
    s:=chr(n mod 10+ord('0'))+s;
    n:=n div 10;
  end;
  NumStr:=s;
end;

const
  funcstat : array[0..15] of integer = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  hex : string[16] = '0123456789ABCDEF';

Procedure DebugOut(func:word;active:boolean);
var i:integer;
begin
  for i:=0 to 15 do
    if active and (i=func) then begin
      inc(funcstat[i]);
      if funcstat[i]>99 then funcstat[i]:=0;
      ScreenStr(hex[i+1]+':'+Numstr(funcstat[i],2),i*5+1,1,15);
    end
    else
      ScreenStr(hex[i+1]+':'+Numstr(funcstat[i],2),i*5+1,1,7);
  ScreenStr('In:'+Numstr(InCount,2)+' Out:'+NumStr(OutCount,2)+
            ' Chk:'+Numstr(CheckInput,2)+' Stat:'+Numstr(LastStatus,2),1,2,7);
end;

(*The ISR for the dummy Fossil driver*)
Procedure New14(Flags, CS, IP, AX, BX,CX, DX, SI, DI, DS, ES, BP: Word);
interrupt;
begin
  {DebugOut(hi(ax),TRUE);}
  case hi(ax) of
    00 : begin (*Set Baud Rate*)
           AX:=OutRoomAvail or OutBuffEmpty or CarrierDetect;
         end;
    01 : begin (*Transmit Wait*)
           AddToOut(lo(ax));
           if Carrier then
             AX:=OutRoomAvail or CarrierDetect
           else
             AX:=0;
           OutsPerRequest:=5;
         end;
    02 : begin (*Receive Wait*)
           Ax:=ReadChar;
         end;
    03 : begin (*Request Status*)
           if OutsPerRequest=0 then
           begin
             if (OutCount>0)  then WriteOut;
             OutsPerRequest:=5;
           end;
           Dec(OutsPerRequest);

           if Carrier then
             AX:=OutRoomAvail or OutBuffEmpty or CarrierDetect
           else
             AX:=0;
           if BufferNotEmpty then
             AX:=AX or InputAvail;
         end;
    04 : begin (*Init Driver*)
           AX:=$1954; (*id*)
           bx:=$100F; (*Doc ref:  10    Max funcs : 0x0F*)
         end;
    05 : begin (*Deinit Driver*)
           If OutCount>0 then WriteOut;
           ClosePipe;
         end; 
    06 : begin (*Return Timertick Parameters*)
           Ax:=$121C;
           Dx:=55;
         end; 
    08 : if Outcount>0 then
         begin
       {    WriteOut; (*Flush Buffer*)}
         end;
    09 : OutCount:=0;                 (*Purge Buffer*)
   $0A : InCount:=0; (*Purge Input Buffer*)
   $0B : begin       (*Transmit no Wait*)
           AddToOut(lo(ax));
           ax:=1; (*accepted*)
           OutsPerRequest:=5;
         end;
   $0C : begin (*Non-Destructive Read-Ahead*)
           If BufferNotEmpty then
             ax:=InBuffer[0] (*Get first char, non destructive*)
           else
             Ax:=$FFFF; (*Not Avail*)
         end;
   $0D : begin
           if Keypressed then
           begin
             Ax:=ord(Readkey);
             if ax=0 then
               ax:=ord(Readkey) shl 8;
           end
           else
            Ax:=$FFFF;
         end;
   $0E : begin
           Ax:=ord(Readkey);
           if ax=0 then
             ax:=ord(Readkey) shl 8;
         end;
   $0F : begin end; (*Enable/Disable Flow Control*)
  end;
  {DebugOut(hi(ax),FALSE);}
end;


Procedure  UnBlockPipe(var f:File);
var info:word;
    regs:registers;

begin
  with regs do
  begin
    ax:=$5F34; (* LOCAL DosQNmPHandState *)
    bx:=filerec(f).handle;
    MsDos(Regs);
    al:=0;
    cx:=ax or (1 shl 15);
    ax:=$5F34; (* LOCAL DosSetNmPHandState *)
    bx:=filerec(f).handle;
    MsDos(Regs);
  end;
end;

var ch:char;
    commandline:string;
    i : integer;

begin
  if Paramcount>1 then
  begin
    commandline:='';
    for i:=2 to Paramcount do
      commandline:=commandline+' '+paramstr(i);
    CheckInput:=CheckInputEach;
    Writeln('Waiting for FOSSDUMM-Pipe to be installed. Press ESC to abort.');
    assign(Pipe,'\PIPE\DUMMOUT.'+paramstr(1));
    repeat
      rewrite(Pipe,1);
      if keypressed then
        if readkey=#27 then
        begin
          writeln('FossDumm aborted');
          Halt(1);
        end;
    until IoResult=0;
    writeln('DUMMOUT installed');
    assign(Signal,'\PIPE\DUMMSIG.'+paramstr(1));
    repeat
      rewrite(Signal);
    until IoResult=0;
    writeln('DUMMIN installed');
    OutCount:=0;
    InCount:=0;
    OutsPerRequest:=5;
    MyPsp:=GetPsp;

    UnBlockPipe(Pipe);
    UnBlockPipe(File(Signal));

    Carrier:=TRUE;
    Strout('starting DUMMFOSS... by Michael Mrosowski');
    WriteOut;

    Writeln('DummFossil Installed');
    Old14:=IntTable[$14];
    IntTable[$14]:=@New14;
    SwapVectors;
    Exec(GetEnv('COMSPEC'),'/C '+commandline);
    SwapVectors;
    IntTable[$14]:=Old14;

    Write(Signal,StopIt);
    Close(Signal);
    i:=Ioresult;
    if not Carrier then
      Writeln('Carrier lost');
  end
  else writeln('Please pass the nodeno and program/batchfile to execute as parameter.');
end.
