// This is the structure for phonebook entries in ZOC.
// Maybe someone likes to use this for a converter program
// Send any questions to M.SCHMIDT@MSN.RMI.DE


// !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!!
// A PHONEBK file must begin with an nine byte header string "BOOKV.VV\032"
// where V.VV is the version of ZOC which introduced this phonebook format.
// All PHONEBK files compatible with this format will carry this version,
// even if written with a future version of ZOC 
// !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!!


#define PH_FILENAME "PHONEBK"
#define PH_INIT  	"BOOK"
#define PH_VERSION	"0.98"
#define PH_TRAIL	"\032"
#define PH_HEADER   (PH_INIT PH_VERSION PH_TRAIL)

// Not packed, each member aligned to 4-byte boundary
// int=32bit
#pragma pack(4)

typedef struct _PHONEBOOK_098 {
	int 	book;				// nr of phonebook to put it in
	char	name[32+1],			// name
			value[64+1],		// number or name of script
			seropt[10+1],		// serial options like 38400-8N1
			optfile[64+1],		// name of options file to load
			logname[64+1],		// name of logfile to open
			waitsend[160+1];	// sequence of waits and sends for login
	int 	valtype;			// type of value (0=dial,1=xdial,2=script)
	BOOL 	qaccess;			// quick access from menu (TRUE=1, FALSE=0)
	int 	zone;				// zone for phone units (a=0, b=1, c=2, d=3)
	int 	emu;				// emulation (0=as is, 1=ansi, 2=vt100, 3=tty)
	int 	future[18];			// for future use, set to zero
	int 	__idm;				// don't touch. If new, set to zero
} PHONEBOOK_098;

#pragma pack()



// define currently up-to-date as PHONEBK
typedef PHONEBOOK_098 PHONEBOOK;
