#! /bin/sh 

echo "mintaka:/projects/Network/release/Update starting."

cd /projects/Network/release

/bin/rm -f Hosts.new Hosts.old

./NEAR.make
./JvNC.make
./OSU.make

/bin/grep -v "\.MIT\." /u/hosts/hosts.nic |
	/bin/grep -v NEARNET-GW >Hosts.new
/bin/cat >>Hosts.new \
	/u/hosts/hstxxx.txt \
	Hosts.OSU \
	Hosts.JvNC \
	Hosts.NEAR \
	/u/hosts/hstcamp.txt \
	/u/hosts/hstmit.txt

if [ `/bin/ls -s Hosts|/bin/awk '{print $1}'` -gt `/bin/ls -s Hosts.new|/bin/awk '{print $1*1.2}'` ]; then
	/bin/echo "New Hosts file too small" 
	/bin/ls -lag
	/bin/ls -lag|/usr/ucb/mail -s "Hosts too small in MINTAKA:/projects/Network/release/" MAP=Status
	exit 1
fi
/bin/rm -f Hosts.old
/bin/ln Hosts Hosts.old
/bin/mv Hosts.new Hosts


# Now extract just the "Local" to LCS hosts
IP='[^0-9\.]18\.('`awk -F. '{r=r s $2;s="|"}
	END{print r}' /u/hosts/lcs.subnets`')\.'
CH='CHAOS *('`awk -F. '{r=r s sprintf "%o",$2/2;
	      if ($2%2)
		r=r "[4-7]";
	      else
		r=r "[0-3]";
	      s="|"
	     }
	END { print r } ' /u/hosts/lcs.subnets`')[0-7][0-7][^0-7]'
echo Doing selection
echo 'IP="'"$IP"'"'
echo 'CH="'"$CH"'"'
( echo "; List of hosts registered in LCS domain or on LCS managed nets" ;
  echo "; Built by `/usr/ucb/whoami` on `/bin/hostname` at `/bin/date`" ;
  echo "" ;
  /usr/bin/egrep "\.LCS\.MIT\.EDU[^A-Z]|$IP|$CH" Hosts
 )	> Local-Hosts


# Now build the list of how many of which systems
( echo "Table of system types registered in LCS domain or on LCS managed nets";
  echo "Built by `/usr/ucb/whoami` on `/bin/hostname` at `/bin/date`" ;
  echo "" ;
  /bin/awk -F: 'NF>5{print $4,$5}' Local-Hosts |
	/usr/bin/sort | /usr/bin/uniq -c | /usr/bin/sort -rn |
	/bin/awk '{printf "%4d  %ss running %s.\n",$1,$2,$3;t+=$1}
		END{printf "----  ------\n%4d  Total.\n",t}'
 )	> Systems



#
# Now install copies in the anonymous ftp area...
#
/bin/cp Systems *Hosts *.Geometry *.mib *.map map watch watch.conf /common/nets

echo "mintaka:/projects/Network/release/Update complete."
