#include "point.h"
#include "rect.h"
#include "stack.h"

main()
{
    cout << "\nTest class Stack\n";
    Rectangle a(0,0,10,10);     // create Rectangle, a
    Point A(1,2);               // create Point, A
    Point B(3,4);               // create Point, B

    Object* C = A.copy();       // C is a generic pointer
                                // pointing to a copy
                                // of the Point, A

    Stack s(10);                // create polymorphic Stack, s
    s.push(B);                  // push Point B onto s
    s.push(a);                  // push Rectangle onto s
    s.push(A);                  // push Point A onto s

    cout << s << "\n";
    cout << "top compare C = " << s.top()->compare(*C) << "\n";
    cout << *(s.pop()) << "\n"; // pop Point and print
    cout << *(s.top()) << "\n"; // print Rectangle (a), stack not changed
    s.pop();                    // pop a
    s.pop();                    // pop B
    s.pop();                    // should print error to stderr
    return 0;
}
