(*--------------------------------------------------------------------------*)
(*                 TestSigF --- Test F significance routine                 *)
(*--------------------------------------------------------------------------*)

PROGRAM TestSigF;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestSigF                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate F-significance routine in PIBSIGS.LBR            *)
(*                                                                          *)
(*   Usage:    This program prompts for an F-value and corresponding        *)
(*             numerator and denominator degrees of freedom.  It computes   *)
(*             and prints the significance level for the gievn F value.     *)
(*                                                                          *)
(*             To stop the program, enter a t value of -99.                 *)
(*                                                                          *)
(*   Calls:    SigF                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   F:    REAL;
   Dfh:  REAL;
   Dfe:  REAL;
   P:    REAL;
   Done: BOOLEAN;

(*$I SIGCONST.PAS *)
(*$I LOGTEN.PAS   *)
(*$I POWTEN.PAS   *)
(*$I ALGAMA.PAS   *)
(*$I CDBETA.PAS   *)
(*$I SIGF.PAS     *)

BEGIN (* TestSigF *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter F-value, numerator DF, and denominator DF (-99 to stop): ');
      READLN( F, Dfh, Dfe );

      IF ( F <> -99.0 ) THEN
         BEGIN
            P     := SigF( F, Dfh, Dfe );
            WRITELN('Significance value = ',P:8:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestSigF *).