(*--------------------------------------------------------------------------*)
(*                 TestInvF --- Test inverse F routine                      *)
(*--------------------------------------------------------------------------*)

PROGRAM TestInvf;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestInvF                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate inverse F routine in PIBSIGS                     *)
(*                                                                          *)
(*   Usage:    This program prompts for a p-value and numerator and         *)
(*             denominator degrees of freedom.  It computes and prints      *)
(*             the corresponding percentage point of the central F          *)
(*             distribution.                                                *)
(*                                                                          *)
(*             Note:  the input probability is the tail value, not the      *)
(*                    cumulative probability.                               *)
(*                                                                          *)
(*             To stop the program, enter a p-value of -99.                 *)
(*                                                                          *)
(*   Calls:    Finv                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   F:    REAL;
   Dfh:  REAL;
   Dfe:  REAL;
   P:    REAL;
   Done: BOOLEAN;

(*$I SIGCONST.PAS *)
(*$I LOGTEN.PAS   *)
(*$I POWERI.PAS   *)
(*$I POWTEN.PAS   *)
(*$I ALGAMA.PAS   *)
(*$I CDBETA.PAS   *)
(*$I NINV.PAS     *)
(*$I BETAINV.PAS  *)
(*$I FINV.PAS     *)

BEGIN (* TestInvf *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter tail prob., num. and den. DF (-99 to stop):  ');
      READLN( P, Dfh, Dfe );

      IF ( P > 0.0 ) THEN
         BEGIN
            F     := Finv( P, Dfh, Dfe );
            WRITELN('F percentage point = ',F:12:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestInvf *).