{  _______________________________________________________________
  |                                                               |
  |            CopyRight (c) 1989,1990  Steven Lutrov             |
  |_______________________________________________________________|____
  |                                                               |    |
  |  Program Title : Unit88.Pas                                   |    | ___
  |  Author        : Steven Lutrov                                |    |    |
  |  Revision      : 2.01                                         |    |    |
  |  Date          : 1990-03-16                                   |    |    |
  |  Language      : Turbo Pascal 5.5                             |    |    |
  |                                                               |    |    |
  |  Description   : Unit File for All the Assembly Routines      |    |    |
  |                : Scr88_21.Asm Str88_21.Asm Fil88_21.Asm       |    |    |
  |                : Grp88_21.Asm Bit88_21.Asm Kbd88_21.Asm       |    |    |
  |                                                               |    |    |
  |_______________________________________________________________|    |    |
      |                                                                |    |
      |________________________________________________________________|    |
          |                                                                 |
          |_________________________________________________________________|

}
                          Unit      Unit88;


(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
                                   Interface
(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

Uses Crt;


Const
       Black        = 0;              _Black        = 0;
       Blue         = 1;              _Blue         = 16;
       Green        = 2;              _Green        = 32;
       Cyan         = 3;              _Cyan         = 48;
       Red          = 4;              _Red          = 64;
       Magenta      = 5;              _Magenta      = 80;
       Brown        = 6;              _Brown        = 96;
       White        = 7;              _White        = 112;
       Grey         = 8;              _Grey         = 128;
       HBlue        = 9;              _HBlue        = 144;
       HGreen       = 10;             _HGreen       = 160;
       HCyan        = 11;             _HCyan        = 176;
       HRed         = 12;             _HRed         = 192;
       HMagenta     = 13;             _HMagenta     = 208;
       Yellow       = 14;             _Yellow       = 224;
       HWhite       = 15;             _HWhite       = 240;

{        Contants for Simplified Screen Attributes
         Underscore Denotes Background Setting

         E.g.     HBlue      = High Intensity Blue
                  Red+_Green = Green Background and Red Foreground
}

Type
       Stype             =  String[80]; { String Type Used for Screens Etc   }

Var
       ErrReturn         :  Byte;       {Used to Report Errors on Some Calls }
       Video_Buff        :  Word;       { Address of Video Buffer            }
       Snow_Check        :  Boolean;    { Check for Snow on Screen Writes    }
       Video_Page        :  Byte;       { Video Page Used for Screen Writes  }
       Textattr          :  Byte;       { The Text Attribute Byte Setting    }
       Startline         :  Byte;
       Stopline          :  Byte;

(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

Function  Bytetohex(Work_: Byte): Stype;
Function  Rotatewordleft(Work_: Word; Bits_: Byte): Word;
Function  Rotatebyteright(Work_,Bits_: Byte): Byte;
Function  Rotatebyteleft(Work_,Bits_:Byte): Byte;
Function  Rotatewordright(Work_: Word; Bits_: Byte): Word;
Function  Wordtohex(Work_: Word): Stype;

Function  CloseFile(Handle:Integer):Boolean;
Function  CreateFile(Fname:String; Attribute:Integer):Integer;
Function  EraseFile(Name:String):Integer;
Function  FMovePointer(Handle,Mode:Integer;Offset:Longint;Var Location: Longint):Boolean;
Function  Getverify: Boolean;
Function  Getvolume(Disk: Integer; Workarea: Pointer): Stype;
Function  OpenFile(Name:String; Access:Integer):Integer;
Function  ReadFile(Handle:Word; Amount:Word; Var Buff):Integer;
Procedure Readsector(Segment,Offset,Drive,Sector,Number: Word);
Procedure Setverify(Setting: Boolean);
Procedure Setvolume(Disk: Integer; Newlabel: Stype; Workarea: Pointer);
Function  WriteFile(Handle:Integer; Nwrite:Word; Var Buff):Integer;
Procedure Writesector(Segment,Offset,Drive,Sector,Number: Word);

Procedure Clearpage(Pagenumber,Colour: Byte);
Procedure CopyClear(Box: Pointer; X_Pos,Y_Pos,X_Num,Y_Num,Colour: Byte);
Procedure Drawbox(Char_X ,Char_Y :Char;X_Pos,Y_Pos,X_Num,Y_Num,Colour:Byte);
Procedure FillScreen(Ch: Char; X_Pos,Y_Pos,X_Num,Y_Num,Colour: Byte);
Procedure RestoreScreen(Box: Pointer; X_Pos,Y_Pos,X_Num,Y_Num: Byte);
Procedure SaveScreen(Box: Pointer; X_Pos,Y_Pos,X_Num,Y_Num: Byte);
Procedure ScreenDown(Box: Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Num: Byte);
Procedure ScreenLeft(Box:Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Num: Byte);
Procedure ScreenRight(Box:Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Num: Byte);
Procedure ScreenUp(Box: Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Num: Byte);
Procedure Scrollx(Where: Char; X_Pos,Y_Pos,X_Num,Y_Num,Cols,Colour: Byte);
Procedure Scrolly(Where: Char; X_Pos,Y_Pos,X_Num,Y_Num,Lines,Colour: Byte);
Procedure SwapPage(Box: Pointer; Pagenumber: Byte);

Function  Altkeydown: Boolean;
Function  Capslockdown: Boolean;
Function  Capslockon: Boolean;
Procedure Clearbuffer;
Procedure Clearcapslock;
Procedure Clearins;
Procedure Clearnumlock;
Procedure Clearscrolllock;
Function  Ctrlkeydown: Boolean;
Function  FreshChar: Char;
Function  Getscan: Byte;
Function  Inskeydown: Boolean;
Function  Inskeyon: Boolean;
Procedure Keypause(Code: Char; Ascii: Boolean; Wait_A,Wait_B: Byte);
Function  LastKey: Char;
Function  Leftshiftdown: Boolean;
Function  Nextkey: Char;
Function  Numlockdown: Boolean;
Function  Numlockon: Boolean;
Function  Readchar: Char;
Function  Rightshiftdown: Boolean;
Function  Scrolllockdown: Boolean;
Function  Scrolllockon: Boolean;
Procedure Setcapslock;
Procedure Setins;
Procedure Setnumlock;
Procedure Setscrolllock;

Procedure Background(Code: Char);
Procedure BlinkOff;
Procedure Blinkon;
Procedure Colourx(X_Pos,Y_Pos,Y_Pos,Colour: Byte);
Procedure Cursordown(Y_Pos: Integer);
Procedure Cursorleft(Columns: Integer);
Procedure Cursoroff;
Procedure Cursoron;
Procedure Cursorright(Columns: Integer);
Procedure Cursorup(Y_Pos: Integer);
Procedure Dsp(Strx: Stype);
Procedure DspAt(Strx: Stype; X_Pos,Y_Pos,Colour: Byte);
Procedure DspColour(Strx: Stype; Colour: Byte);
Procedure DspEnd(Strx: Stype; X_Pos,Y_Pos,Length,Colour: Byte);
Procedure DspJust(Strx: Stype; X_Pos,Y_Pos,Colour: Byte);
Procedure Dspln(Strx: Stype);
Procedure DspLnColour(Strx: Stype; Colour: Byte);
Procedure DspPart(Strx: Stype; Start,Numch,X_Pos,Y_Pos,Colour: Byte);
Procedure DspVert(Strx: Stype; X_Pos,Y_Pos,Colour: Byte);
Procedure Foreground(Code: Char);
Procedure Formatleft(Strx: Stype; How_Many: Integer; Colour: Byte);
Procedure Formatright(Strx: Stype; How_Many: Integer; Colour: Byte);
Function  GetColour(X_Pos,Y_Pos: Byte): Byte;
Function  Getpage: Integer;
Procedure Intenseoff;
Procedure Intenseon;
Procedure Normal;
Procedure Reverse;
Procedure RowColour(X_Pos,Y_Pos,X_Num,Colour: Byte);
Procedure ScreenColour(X_Pos,Y_Pos,X_Num,Y_Pos,Colour: Byte);
Procedure SetColour(X_Pos,Y_Pos,Colour: Byte);
Procedure Setpage(Pagenumber: Integer);

Procedure ChangeChar(Var Strx: Stype; Search,Replace: Char);
Function  Compare(Strg1,Strg2: Stype): Boolean;
Procedure Deletechar(Var Strx: Stype; Ch: Char);
Procedure Deleteleft(Var Strx: Stype; Border: Char);
Procedure Deleteright(Var Strx: Stype; Border: Char);
Function  Leftend(Var Strx: Stype; Border: Char): Stype;
Procedure Lowercase(Var Strx: Stype);
Procedure Overwrite(Var Strx: Stype; Substrg: Stype; Position: Integer);
Procedure Padcentre(Var Strx: Stype; Ch: Char; Position,Length: Integer);
Procedure Padends(Var Strx: Stype; Ch: Char; Length: Integer);
Procedure Padleft(Var Strx: Stype; Ch: Char; Length: Integer);
Procedure Padright(Var Strx: Stype; Ch: Char; Length: Integer);
Procedure Replace(Var Strx: Stype; Substrg: Stype; Position,Chars: Integer);
Function  Rightend(Var Strx: Stype; Border: Char): Stype;
Function  Seekstring(Strx,Substrg: Stype; Startpt: Integer):Integer;
Function  StringEnd(Strx: Stype; Numberchars: Integer): Stype;
Function  StringOf(Substrg: Stype; Length: Integer): Stype;
Procedure Uppercase(Var Strx: Stype);
Function  Wordcount(Strx: Stype): Integer;



{ Routines That are Partially Assembly Written }

Procedure DspC(Strx : Stype ;Y_Pos,Colour:Byte);


(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
                              Implementation
(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

{$F+}                       {All Aseembly Routines Use  Far Calls for Linking}

{$L Bit88_21.Obj}
Function  Bytetohex;External;
Function  Rotatewordleft;External;
Function  Rotatebyteright;External;
Function  Rotatebyteleft;External;
Function  Rotatewordright;External;
Function  Wordtohex;External;


{$L Fil88_21.Obj}
Function  CloseFile;External;
Function  CreateFile;External;
Function  EraseFile;External;
Function  FMovePointer;External;
Function  Getverify;External;
Function  Getvolume;External;
Function  OpenFile;External;
Function  ReadFile;External;
Procedure Readsector;External;
Procedure Setverify;External;
Procedure Setvolume;External;
Function  WriteFile;External;
Procedure Writesector;External;

{$L Grp88_21.Obj}
Procedure Clearpage;External;
Procedure CopyClear;External;
Procedure Drawbox;External;
Procedure FillScreen;External;
Procedure RestoreScreen;External;
Procedure SaveScreen;External;
Procedure ScreenDown;External;
Procedure ScreenLeft;External;
Procedure ScreenRight;External;
Procedure ScreenUp;External;
Procedure Scrollx;External;
Procedure Scrolly;External;
Procedure SwapPage;External;

{$L Kbd88_21.Obj}
Function  Altkeydown;External;
Function  Capslockdown;External;
Function  Capslockon;External;
Procedure Clearbuffer;External;
Procedure Clearcapslock;External;
Procedure Clearins;External;
Procedure Clearnumlock;External;
Procedure Clearscrolllock;External;
Function  Ctrlkeydown;External;
Function  FreshChar;External;
Function  Getscan;External;
Function  Inskeydown;External;
Function  Inskeyon;External;
Procedure Keypause;External;
Function  LastKey;External;
Function  Leftshiftdown;External;
Function  Nextkey;External;
Function  Numlockdown;External;
Function  Numlockon;External;
Function  Readchar;External;
Function  Rightshiftdown;External;
Function  Scrolllockdown;External;
Function  Scrolllockon;External;
Procedure Setcapslock;External;
Procedure Setins;External;
Procedure Setnumlock;External;
Procedure Setscrolllock;External;

{$L Scr88_21.Obj}
Procedure Background;External;
Procedure BlinkOff;External;
Procedure Blinkon;External;
Procedure Colourx;External;
Procedure Cursordown;External;
Procedure Cursorleft;External;
Procedure Cursoroff;External;
Procedure Cursoron;External;
Procedure Cursorright;External;
Procedure Cursorup;External;
Procedure Dsp;External;
Procedure DspAt;External;
Procedure DspColour;External;
Procedure DspEnd;External;
Procedure DspJust;External;
Procedure Dspln;External;
Procedure DspLnColour;External;
Procedure DspPart;External;
Procedure DspVert;External;
Procedure Foreground;External;
Procedure Formatleft;External;
Procedure Formatright;External;
Function  GetColour;External;
Function  Getpage;External;
Procedure Intenseoff;External;
Procedure Intenseon;External;
Procedure Normal;External;
Procedure Reverse;External;
Procedure RowColour;External;
Procedure ScreenColour;External;
Procedure SetColour;External;
Procedure Setpage;External;

{$L Str88_21.Obj}
Procedure ChangeChar;External;
Function  Compare;External;
Procedure Deletechar;External;
Procedure Deleteleft;External;
Procedure Deleteright;External;
Function  Leftend;External;
Procedure Lowercase;External;
Procedure Overwrite;External;
Procedure Padcentre;External;
Procedure Padends;External;
Procedure Padleft;External;
Procedure Padright;External;
Procedure Replace;External;
Function  Rightend;External;
Function  Seekstring;External;
Function  StringEnd;External;
Function  StringOf;External;
Procedure Uppercase;External;
Function  Wordcount;External;

{$F-}                                             {Turn Off Far Call Linking}


(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
Procedure DspC (Strx : Stype ;Y_Pos,Colour:Byte);

  Begin
        DspAt(Strx,40 - Length(Strx) Div 2,Y_Pos,Colour);
  End;

(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

Begin

     Video_Buff   := $B800;   {Vga and Ega Mode}
     Snow_Check   := True;    {Normaly Should be Checked}
     Video_Page   := 0;       {Initialy Video page Should 0}

End.


