#include "ws_glob.h"
#include "winftp.h"
#include "winicmp.h"
#include <stdio.h>
#include <stdlib.h> 
#include <direct.h>
#include <dos.h>

#include <stdarg.h>

static char szPingHost[80];
static HOSTENT HostEntry;
static LPHOSTENT phe;
static PROTOENT ProtoEntry;
static LPPROTOENT ppe; 
static HANDLE hTaskAsyncHost, hTaskAsyncProto;
static HANDLE hStdCursor, hWaitCursor;
static int nIndex, nRC, nBytesRecv;
static int nTransmitted, nReceived;
static int saFromAddrLen;
static int nPktLength=50;
static int nNumPkts=10;
static u_long lTotalTime,lMinTime,lMaxTime;
static bPingInProgress=FALSE;

SOCKET sockPing=INVALID_SOCKET;

int nMaxWait=5000;  // milliseconds
int nExtent=0;
int nExtra =0;

//************************************************************************
//  Add a line to the Ping List Box
//************************************************************************
void AddPingLine (HWND hDlg, LPSTR lpStr)
{
  HDC hDC;
  HWND hWnd;
  SIZE size;
  
  if (lpStr==NULL) return;
  if (!bVerbose && lpStr[0]=='[') return;
  SendDlgItemMessage (hDlg, IDD_LBPING, LB_ADDSTRING, (WPARAM) 0, (LPARAM)(LPCSTR) lpStr);
  if (nExtra==0) nExtra = GetSystemMetrics (SM_CXVSCROLL);
  hDC = GetDC (hWnd=GetDlgItem (hDlg, IDD_LBPING));
  SelectObject (hDC, GetStockObject (ANSI_FIXED_FONT));
  GetTextExtentPoint (hDC, lpStr, lstrlen (lpStr), &size);
  ReleaseDC (hWnd, hDC);
  if ((size.cx+nExtra)>nExtent) SendDlgItemMessage (hDlg, IDD_LBPING, LB_SETHORIZONTALEXTENT, (WPARAM) (nExtent=size.cx+2*nExtra), 0L);
}

//*************************************************************************
//*************************************************************************
void DoDlgPrintf (HWND hDlg, char *szFormat,...)
{
   va_list vaArgs;
   static char szBuf[256];

   va_start (vaArgs, szFormat);
   if (vsprintf (szBuf, szFormat, vaArgs)!=EOF) AddPingLine (hDlg, szBuf);
   va_end (vaArgs);
}

//*************************************************************************
//*************************************************************************
void PrintHeader (HWND hDlg, LPSOCKADDR_IN saDestAddr, int nDataSize)
{
  DoDlgPrintf (hDlg, "PING %s (%s): %u data bytes",
      szPingHost, inet_ntoa (saDestAddr->sin_addr), nDataSize+SIZE_ICMP_HDR);
  lMaxTime=lTotalTime=0l; 
  lMinTime=99999999l;
}

//*************************************************************************
//*************************************************************************
void PrintStats (HWND hDlg) 
{
  AddPingLine (hDlg, " ");
  DoDlgPrintf (hDlg, "PING Statistics for %s", szPingHost);
  if (nTransmitted && nReceived)
    DoDlgPrintf (hDlg, "%d packets transmitted, %d packets received, %d%% packet loss",
        nTransmitted, nReceived, (int)(((nTransmitted-nReceived)*100)/nTransmitted));
  else if (nTransmitted)
    DoDlgPrintf (hDlg, "%d packets transmitted, %d packets received, 100%% packet loss",
      nTransmitted, nReceived);
  if (nReceived)
    DoDlgPrintf (hDlg, "round-trip (ms) min/avg/max = %ld/%ld/%ld",
         lMinTime, lTotalTime/nReceived, lMaxTime);
  AddPingLine (hDlg, " ");
  AddPingLine (hDlg, " ");
}

//************************************************************************
// compute packet checksum
//************************************************************************
int in_cksum (u_short FAR *pPacket, int nBytes)
{
  long sum;
  u_short oddbyte;
  u_short answer;

  sum=0l;
  while(nBytes>1) { sum += *pPacket++; nBytes -= 2; }
  if(nBytes==1) 
  {
    oddbyte=0;
    *((u_char FAR *) &oddbyte) = *(u_char FAR *)pPacket;
    sum += oddbyte;
  }
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  answer= (u_short) ~sum;
  return (answer);
}

//************************************************************************
//************************************************************************
LPSTR ReturnICMPType (int nType)
{
  static char *ICMPTypeTable[]={
    "Echo Reply", "ICMP 1", "ICMP 2", "DestUnrchbl",
    "SrcQnch", "Redirect", "6", "7","Echo","9","10",
    "Time Exceed", "ParamPrblm", "Timestamp", "Timestamp reply",
    "InfoRqst", "InfoRply"
  };

  if(nType<0 || nType>16) return "Out-of-range";
  return ICMPTypeTable[nType];
}

//************************************************************************
//************************************************************************
BOOL PrintPkt (HWND hDlg, LPSTR pPacket, int nLength, LPSOCKADDR_IN saFromAddr, BOOL bVerbose)
{
  int iphdrlen;
  static struct ip *ip;
  static struct icmp *icmp;
  static struct in_addr *iptr;
  u_long ulrc;
  static u_long lEndTime,*lpStartTime,lTripTime;

  lEndTime = GetTickCount();
  saFromAddr->sin_addr.s_addr = ntohl (saFromAddr->sin_addr.s_addr);
  ip = (struct ip *) pPacket;
  iphdrlen = ip->ip_hl << 2;
  if (nLength < iphdrlen + ICMP_MINLEN) 
  {
    if(bVerbose) 
    {
      ulrc=ntohl (saFromAddr->sin_addr.s_addr);
      iptr = (struct in_addr *) &ulrc;
      DoDlgPrintf (hDlg, "[received] too short (%d bytes) from %s\n", nLength, inet_ntoa(*iptr));
    }
    return FALSE;
  }
  nLength -= iphdrlen;
  icmp=(struct icmp *)(pPacket + iphdrlen);
  if (icmp->icmp_type != ICMP_ECHOREPLY) 
  {
    if (bVerbose) 
    {
      ulrc=ntohl(saFromAddr->sin_addr.s_addr);
      iptr = (struct in_addr *) &ulrc;
      DoDlgPrintf (hDlg, "[received] %d bytes from %s: icmp_type=%d (%s) icmp_code=%d",
        nLength, inet_ntoa(*iptr), icmp->icmp_type, ReturnICMPType(icmp->icmp_type), icmp->icmp_code);
    }
    return FALSE;
  }

  ulrc = ntohl (saFromAddr->sin_addr.s_addr);
  iptr = (struct in_addr *) &ulrc;

  if (icmp->icmp_id!=(WORD) hDlg) 
  {
    DoDlgPrintf (hDlg, "RCV %d bytes from %s. not for us", nLength, inet_ntoa (*iptr));
    return FALSE;
  }
  lpStartTime = (u_long *) (pPacket + SIZE_ICMP_HDR);
  lTripTime = lEndTime - *lpStartTime;
  lTotalTime += lTripTime;
  if(lTripTime < lMinTime) lMinTime=lTripTime;
  if(lTripTime > lMaxTime) lMaxTime=lTripTime;

  DoDlgPrintf (hDlg, "%-12s:(%3d) %6ldms %4d bytes",
       inet_ntoa(*iptr), icmp->icmp_seq, lTripTime, nLength);

  nReceived++;

  return TRUE;
}

//************************************************************************
//************************************************************************
int send_ping (HWND hDlg, SOCKET sockfd, LPSOCKADDR_IN saDestAddr, LPSTR pPacket, int nLength)
{
  int nRC;
  struct icmp *icmp;
  u_long *timeloc;

  nLength+=SIZE_ICMP_HDR;
  icmp=(struct icmp *)pPacket;
  // set the send time
  timeloc= (u_long *) (pPacket+SIZE_ICMP_HDR);
  *timeloc=GetTickCount();
  // complete the ICMP packet header
  icmp->icmp_type=ICMP_ECHO;
  icmp->icmp_code=0;
  icmp->icmp_cksum=0;
  icmp->icmp_id = (int) hDlg;
  icmp->icmp_seq=nTransmitted;
  // compute the checksum
  icmp->icmp_cksum = in_cksum ((u_short FAR *) icmp, nLength);
  // send the packet
  if ((nRC = sendto (sockfd, pPacket, nLength,0, (struct sockaddr *) saDestAddr,
                 sizeof(struct sockaddr)))==SOCKET_ERROR) 
  {
    DoDlgPrintf(hDlg, "[sendto] %s", ReturnWSError (WSAGetLastError(), NULL));
    if (WSAGetLastError()!=WSAEWOULDBLOCK && WSAGetLastError()!=WSAEINPROGRESS)
      nTransmitted++;
  } 
  else 
  {
    nTransmitted++;
    if (nRC!=nLength)
      DoDlgPrintf (hDlg, "[sendto] wrote %d bytes, return=%d",nLength,nRC);
  }

  return (nRC==nLength);
}

//************************************************************************
//************************************************************************
recv_ping (HWND hDlg, SOCKET sockfd, LPSTR szRecvPkt, BOOL bPrintFlag)
{
  int  nBytesRecv;
  int  saFromAddrLen;
  struct sockaddr_in  saFromAddr;
  int  nRC;

// NOTE: this is for the blocking version..... this means we won't exit
// until we get the packet(s) we are looking for.  This means we have to
// use a timer function to make us exit.

  nRC = FALSE;
  saFromAddrLen = sizeof (saFromAddr);
  SetTimer (hDlg, 10, nMaxWait, NULL);
  nBytesRecv = recvfrom (sockfd, szRecvPkt, MAXPACKET,0, (struct sockaddr *)&saFromAddr, &saFromAddrLen);
  KillTimer (hDlg, 10);
  if (nBytesRecv!=SOCKET_ERROR || WSAGetLastError()!=WSAEINTR) 
  {
    if (nBytesRecv==SOCKET_ERROR) 
    {
      DoDlgPrintf (hDlg, "[recvfrom] %s",ReturnWSError(WSAGetLastError(),NULL));
      return FALSE;
    } 
    else
    {
      nRC = PrintPkt (hDlg, szRecvPkt, nBytesRecv, &saFromAddr, bPrintFlag);
    }
  }
  return nRC;
}

//************************************************************************
//  Run Ping Async mode
//************************************************************************
BOOL DoAsyncPing (HWND hDlg)
{
  bPingInProgress = TRUE;
  memset (&saDestAddr, 0, sizeof(struct sockaddr_in));
  memset (&HostEntry,  0, sizeof(struct hostent));
  memset (&ProtoEntry, 0, sizeof(struct protoent));
  saDestAddr.sin_family=AF_INET;

  if ((saDestAddr.sin_addr.s_addr=inet_addr (szPingHost))==INADDR_NONE)
       hTaskAsyncHost = WSAAsyncGetHostByName (hDlg, WM_PING_HOST, szPingHost, szMsgBuf, MAXGETHOSTSTRUCT);
  else hTaskAsyncHost = 0;
  hTaskAsyncProto = WSAAsyncGetProtoByName (hDlg, WM_PING_PROTO, "icmp", szMsgBuf+MAXGETHOSTSTRUCT, MAXGETHOSTSTRUCT);
  return TRUE;
}

//************************************************************************
//  Run Ping Blocking mode
//************************************************************************
BOOL DoBlockingPing (HWND hDlg)
{
  int nProto;
  
  bPingInProgress = TRUE;
  memset (&saDestAddr, 0, sizeof (struct sockaddr));
  saDestAddr.sin_family = AF_INET;
  if ((saDestAddr.sin_addr.s_addr=inet_addr (szPingHost))==INADDR_NONE)
  {
    if ((phe = gethostbyname (szPingHost))!=NULL)
    {
      memcpy (&saDestAddr.sin_addr, phe->h_addr, phe->h_length);
    }
    else
    {
      DoDlgPrintf (hDlg, "can't get \"%s\" host entry.", szPingHost);
      SendMessage (hDlg, WM_RESETCURSOR, 0, 0l);
      return TRUE;
    }
  }
  if ((ppe=getprotobyname("icmp"))==NULL) 
  {
    DoDlgPrintf (hDlg, "[Proto] Unknown Protocol: icmp Using Default");
    nProto = 1;
  }
  else
  {
    nProto = ppe->p_proto;
  }
  
  if ((sockPing=socket (saDestAddr.sin_family, SOCK_RAW, nProto))==INVALID_SOCKET)
  {
    DoDlgPrintf (hDlg, "Can't Create Raw Socket %s", ReturnWSError (WSAGetLastError(), NULL));
    SendMessage (hDlg, WM_RESETCURSOR, 0, 0l);
    return TRUE;
  }
  SetWindowText (GetDlgItem (hDlg, IDD_PING), "Reset");
  nTransmitted=0; nReceived=0;
  PrintHeader (hDlg, &saDestAddr, nPktLength);
  SetTimer (hDlg, 30, 1000, NULL);
  return TRUE;
}

//************************************************************************
//  Process the IDOK message - Resolve the Name
//************************************************************************
BOOL OnDlgCmdIdOk (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  int nCount = 0;
  char szBuf[30];
  
  GetDlgItemText (hDlg, IDD_HOSTNAME, szPingHost, 79);
  if ((phe = gethostbyname (szPingHost)) == NULL) 
  {
    MessageBox (hDlg, "GetHostByName() failed", "Error", MB_OK);
    return TRUE;
  }
  nCount = 0;
  SendDlgItemMessage (hDlg, IDD_LBALIAS, LB_RESETCONTENT, (WPARAM) 0, (LPARAM) 0);
  SendDlgItemMessage (hDlg, IDD_LBADDR,  LB_RESETCONTENT, (WPARAM) 0, (LPARAM) 0);
  SendDlgItemMessage (hDlg, IDD_LBPING,  LB_RESETCONTENT, (WPARAM) 0, (LPARAM) 0);

  SendDlgItemMessage (hDlg, IDD_LBALIAS, LB_ADDSTRING, 0, (LPARAM) (phe->h_name));
  while (phe->h_aliases[nCount] != NULL) 
  {
    SendDlgItemMessage (hDlg, IDD_LBALIAS, LB_ADDSTRING, 0, (LPARAM) (phe->h_aliases[nCount]));
    nCount++;
  }
  nCount = 0;
  while (phe->h_addr_list[nCount] != NULL) 
  {
    sprintf (szBuf, "%u.%u.%u.%u", (unsigned char) phe->h_addr_list[nCount][0],
       (unsigned char) phe->h_addr_list[nCount][1],
       (unsigned char) phe->h_addr_list[nCount][2],
       (unsigned char) phe->h_addr_list[nCount][3]);
    nCount++;
    if (SendDlgItemMessage (hDlg, IDD_LBADDR, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) szBuf) == LB_ERR)
       MessageBox (hDlg, szBuf, "Couldn't add address..", MB_OK);
  }
  return TRUE;
}

//***********************************************************************
//  Process the IDD_PING command
//***********************************************************************
BOOL OnDlgCmdPingHost (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  if (bPingInProgress) 
  {
    if (sockPing!=INVALID_SOCKET) 
    {
      KillTimer (hDlg, 10);
      KillTimer (hDlg, 20);
      KillTimer (hDlg, 30);
      if (WSAIsBlocking()) WSACancelBlockingCall();
      sockPing = DoClose (sockPing);
      SendMessage(hDlg, WM_RESETCURSOR, 0, 0l);
      SetWindowText (GetDlgItem (hDlg, IDD_PING), "Ping Host");
    }
    bPingInProgress = FALSE; 
    return TRUE;
  }

  if (GetDlgItemText (hDlg, IDD_HOSTNAME, szPingHost, 79)==0) return 0;
  nNumPkts   = GetDlgItemInt (hDlg, IDD_PINGCOUNT, NULL, FALSE);
  nNumPkts = __max (nNumPkts, 1);
  nPktLength = GetDlgItemInt (hDlg, IDD_PKTSIZE, NULL, FALSE);
  nPktLength = __min (__max (nPktLength, sizeof (struct icmp)), MAXPACKET);
  switch ((int) IsDlgButtonChecked (hDlg, IDC_BLOCKINGPING))
  {
    case  0  : DoAsyncPing (hDlg); break;
    default  : DoBlockingPing (hDlg); break;
  }
  return TRUE;
}

//***********************************************************************
//  Process the Cancel Button
//***********************************************************************
BOOL OnDlgCmdCancel (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  if (sockPing!=INVALID_SOCKET) 
  {
    sockPing = DoClose (sockPing);
    SendMessage(hDlg, WM_RESETCURSOR, 0, 0l);
  }
  EndDialog (hDlg, FALSE); 
  return TRUE;
}

//***********************************************************************
//  Process the WM_COMMAND message
//***********************************************************************
BOOL OnDlgCommand (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  int count = 0;
  WORD wNotifyCode;
  WORD wCtlID;

#ifdef WIN32
  wNotifyCode = HIWORD (wParam);
  wCtlID      = LOWORD (wParam);
#else
  wNotifyCode = HIWORD (lParam);
  wCtlID      = wParam;
#endif
  
  switch (wCtlID)
  {
    case IDOK     : OnDlgCmdIdOk (hDlg, wCtlID, wNotifyCode); return TRUE;
    case IDD_PING : OnDlgCmdPingHost (hDlg, wCtlID, wNotifyCode); return TRUE;
    case IDCANCEL : OnDlgCmdCancel (hDlg, wCtlID, wNotifyCode); return TRUE;
    default       : return FALSE;
  }
  return TRUE;
}

//***********************************************************************
//  Process the WM_TIMER message
//***********************************************************************
BOOL OnDlgTimer (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (wParam) 
  {
    case 10: AddPingLine (hDlg, "[Timer-TIMEOUT] ");
             KillTimer (hDlg, 10);
             if (WSAIsBlocking()) WSACancelBlockingCall();
             bPingInProgress = FALSE;
             break;

    case 20: if (nTransmitted<nNumPkts) 
             {
               send_ping (hDlg, sockPing, &saDestAddr, szMsgBuf, nPktLength+SIZE_ICMP_HDR);
               PostMessage(hDlg, WM_PING_RECEIVE, 0, 0l);
             } 
             else 
             {
               KillTimer (hDlg, 20);
               if (nReceived!=nTransmitted) SendMessage (hDlg, WM_PING_RECEIVE, 0, 0l);
               PostMessage (hDlg, WM_PING_FINISH, 0, 0l);
             }
             break;
    case 30: if (nTransmitted<nNumPkts)
             {
               if (send_ping (hDlg, sockPing, &saDestAddr, szMsgBuf, nPktLength+SIZE_ICMP_HDR))
                  recv_ping (hDlg, sockPing, szString, TRUE);
             }
             else 
             {
               KillTimer (hDlg, 30);
               if (nReceived!=nTransmitted) recv_ping (hDlg, sockPing, szString, TRUE);
               PostMessage (hDlg, WM_PING_FINISH, 0, 0l);
             }
             break;
    default: KillTimer (hDlg, wParam);
             break;
  }
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgPingHost (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  if (WSAGETASYNCERROR (lParam)!=0) 
  {
    ReportWSError (NULL, WSAGETASYNCERROR (lParam));
    SendMessage (hDlg, WM_RESETCURSOR, 0, 0l);
  } 
  else 
  {
    memcpy (&HostEntry, szMsgBuf, sizeof (struct hostent));
    memcpy (&saDestAddr.sin_addr, HostEntry.h_addr, HostEntry.h_length);
    hTaskAsyncHost=0;
    if (hTaskAsyncProto==0) PostMessage (hDlg, WM_PING_CAS, 0, 0l);
  }
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgPingProto (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  if (WSAGETASYNCERROR (lParam)!=0) 
  {
    ReportWSError (NULL, WSAGETASYNCERROR (lParam));
    SendMessage (hDlg, WM_RESETCURSOR, 0, 0l);
  } 
  else 
  {
    memcpy (&ProtoEntry, szMsgBuf+MAXGETHOSTSTRUCT, sizeof (struct protoent));
    hTaskAsyncProto=0;
    if (hTaskAsyncHost==0) PostMessage (hDlg, WM_PING_CAS, 0, 0l);
  }
  return 0;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgPingAsync (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  PrintHeader (hDlg, &saDestAddr, nPktLength+SIZE_ICMP_HDR);
  sockPing = socket (saDestAddr.sin_family, SOCK_RAW, ProtoEntry.p_proto);
  if (sockPing==INVALID_SOCKET) 
  {
    DoDlgPrintf (hDlg, "Can't Create Raw Socket: %s", ReturnWSError (WSAGetLastError(), NULL));
    SendMessage (hDlg, WM_RESETCURSOR, 0, 0l);
  } 
  else 
  {
    if (WSAAsyncSelect (sockPing, hDlg, WM_PING_RECEIVE, FD_READ)==SOCKET_ERROR)
    {
      DoDlgPrintf (hDlg, "AsyncSelect: %s", ReturnWSError (WSAGetLastError(), NULL));
      sockPing = DoClose (sockPing);
      SendMessage (hDlg, WM_RESETCURSOR, 0, 0l);
    } 
    else 
    {
      SetWindowText (GetDlgItem (hDlg, IDD_PING), "Reset");
      nTransmitted = nReceived = 0;
      SetTimer (hDlg, 20, 1000, NULL);
    }
  }
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgPingRecv (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  saFromAddrLen = sizeof(struct sockaddr);
  nBytesRecv = recvfrom (sockPing, szString, MAXPACKET, 0, (struct sockaddr *)&saFromAddr, &saFromAddrLen);
  if (nBytesRecv==SOCKET_ERROR) 
  {
    DoDlgPrintf (hDlg, "[Recv] %s", ReturnWSError (WSAGetLastError(), NULL));
  } 
  else
  {
    PrintPkt (hDlg, szString, nBytesRecv, &saFromAddr, TRUE);
  }
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgPingFinish (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  sockPing = DoClose (sockPing);
  KillTimer (hDlg, 10);
  PrintStats (hDlg);
  bPingInProgress = FALSE;
  SetWindowText (GetDlgItem (hDlg, IDD_PING), "Ping Host");
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgResetCursor (hDlg, Msg, wParam, lParam)
{
  bCmdInProgress=FALSE;
  SetCursor(hStdCursor);
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgSetCursor (hDlg, Msg, wParam, lParam)
{
  if (bCmdInProgress) 
  {
    SetCursor (hWaitCursor);
    return TRUE;
  }
  return FALSE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgInitDlg (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  SetDlgItemText (hDlg, IDD_HOSTNAME, szRemoteHost);
  SetDlgItemInt (hDlg, IDD_PINGCOUNT, nNumPkts, FALSE);
  SetDlgItemInt (hDlg, IDD_PKTSIZE, nPktLength, FALSE);
  CheckRadioButton (hDlg, IDC_ASYNCPING, IDC_BLOCKINGPING, IDC_ASYNCPING);
  SendDlgItemMessage (hDlg, IDD_LBPING, WM_SETFONT, (WPARAM) GetStockObject (ANSI_FIXED_FONT), (LPARAM) 0);
  sockPing = INVALID_SOCKET;
  return TRUE;
}

//***********************************************************************
//***********************************************************************
BOOL OnDlgResize (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  int cx=LOWORD (lParam);
  int cy=HIWORD (lParam);
  DWORD dwBase;
  int cxb, cyb;
  int cTmpX, cTmpY;
  
  dwBase = GetDialogBaseUnits();
  cxb = LOWORD (dwBase) / 4;
  cyb = HIWORD (dwBase) / 8;
  if (cxb==0 || cyb==0) return 0;
  cx /= cxb;
  cy /= cyb;
  if (cx<145) return 0;
  if (cy<190) return 0;
  cTmpX = (cx-15)/3;
  cTmpY = cy - 120 - 20;

  MoveWindow (GetDlgItem (hDlg, IDC_BOX_BLOCK), 92*cxb,      0, (cx-92-3)*cxb, 36*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDC_BOX_HOST) ,  2*cxb, 34*cyb, (cx- 2-3)*cxb, 25*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDD_HOSTNAME) , 28*cxb, 41*cyb, (cx-28-7)*cxb, 15*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDC_BOX_ALIAS),  2*cxb, 59*cyb, (cx- 2-3)*cxb, 59*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDD_LBALIAS)  ,  6*cxb, 70*cyb, (cx- 6-7)*cxb, 21*cxb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDD_LBADDR)   ,  6*cxb, 93*cyb, (cx- 6-7)*cxb, 21*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDD_LBPING)   ,  2*cxb,120*cyb, (cx- 2-3)*cxb, cTmpY*cyb, TRUE);
  
  cTmpY += 122;
  
  MoveWindow (GetDlgItem (hDlg, IDOK)    ,           2*cxb, cTmpY*cyb, (cTmpX-2)*cxb, 15*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDD_PING),   (cTmpX+2)*cxb, cTmpY*cyb, (cTmpX-2)*cxb, 15*cyb, TRUE);
  MoveWindow (GetDlgItem (hDlg, IDCANCEL), (2*cTmpX+4)*cxb, cTmpY*cyb, (cTmpX-2)*cxb, 15*cyb, TRUE);

  SendDlgItemMessage (hDlg, IDD_LBPING, LB_SETHORIZONTALEXTENT, (WPARAM) nExtent, 0L);
  return TRUE;
}

//***********************************************************************
// Misc Dialog Window Procedures                                        *
//***********************************************************************
BOOL CALLBACK WS_FindHostProc (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{ 
  switch (Msg)
  {
  	case WM_INITDIALOG  : return OnDlgInitDlg (hDlg, Msg, wParam, lParam);
  	case WM_SIZE        : return OnDlgResize (hDlg, Msg, wParam, lParam);
    case WM_TIMER       : return OnDlgTimer (hDlg, Msg, wParam, lParam);
  	case WM_COMMAND     : return OnDlgCommand (hDlg, Msg, wParam, lParam);
    case WM_PING_HOST   : return OnDlgPingHost (hDlg, Msg, wParam, lParam);
    case WM_PING_PROTO  : return OnDlgPingProto (hDlg, Msg, wParam, lParam);
    case WM_PING_CAS    : return OnDlgPingAsync (hDlg, Msg, wParam, lParam);
    case WM_PING_RECEIVE: return OnDlgPingRecv (hDlg, Msg, wParam, lParam);
    case WM_PING_FINISH : return OnDlgPingFinish (hDlg, Msg, wParam, lParam);
    case WM_RESETCURSOR : return OnDlgResetCursor (hDlg, Msg, wParam, lParam);
    case WM_SETCURSOR   : return OnDlgSetCursor (hDlg, Msg, wParam, lParam);
    default             : return FALSE;
  }
  return FALSE;
}


