#include "ws_glob.h"
#include "winftp.h"
#include <stdlib.h>  
#include <io.h>
#include <string.h>
#include <ctype.h>

#define MAXHOSTS 20
#define GET_CBOX_INDEX(wnd,id,str) (int) SendDlgItemMessage (wnd, id, CB_SELECTSTRING, (WPARAM) 0, (LPARAM) (LPCSTR) str)

LPVIEWERCFG lpViewer;
LPHOSTCONFIG lpHostCfg;
HANDLE hHostCfg;

BOOL bSaveUID=FALSE;
BOOL bSavePWD=FALSE;
BOOL bSaveDir;

char szCrypt[160];

LPSTR lpApp          = "winftp";
LPSTR szUndecipher   = "undecipherable";
LPSTR szAnony        = "anonymous";
LPSTR szProfHostName = "HostName";
LPSTR szProfUserID   = "UserID";
LPSTR szProfHostType = "HostType";
LPSTR szProfTimeOut  = "TimeOut";
LPSTR szProfMailAddr = "MailAddr";
LPSTR szProfViewer   = "Viewer";
LPSTR szProfTempDir  = "TempDir";
LPSTR szProfAutoStart= "AutoStart";
LPSTR szProfRetain   = "Retain";
LPSTR szProfConfigNum= "ConfigNum";
LPSTR szProfFlags    = "Flags";
LPSTR szProfConfig   = "Config";
LPSTR szProfPass     = "Pass";
LPSTR szProfDir      = "Dir";
LPSTR szProfScript   = "Script";
LPSTR szProfFireWall = "FireWall";
LPSTR szProfLogFlag  = "LogFlag";
LPSTR szProfLogFile  = "LogFile";
LPSTR szProfDblClk   = "DblClk";
LPSTR szProfViewPgm  = "Viewer";
LPSTR szProfViewTyp  = "Ext";
LPSTR szProfViewXfer = "Xfer";
LPSTR szProfSaveDir  = "Save";
LPSTR szProfViewCount= "ViewerCount";

LPSTR szProfFireWallHost = "FireWallHost";
LPSTR szProfFireWallUser = "FireWallUser";
LPSTR szProfFireWallPass = "FireWallPass";

LPSTR lpHostTypes[] = { "AutoDetect",  "Unix",    "IBM VM",  "VMS/Multinet",
                        "VMS/UCX", "FTP Software PCTCP", "CUTCP/NCSA", 
                        "NOS/KA9Q", "WinQVT/Net", "IBMPC TCP/IP",
                        "CHAMELEON", "SuperTCP", "SI NT/FTPD", "IBM MVS", 
                        "UniSys 5000" };

int nHostTypes = sizeof (lpHostTypes) / sizeof (char *);

LPSTR lpAcctTypes[] = { "Account not needed", "Account Type 1", 
                        "Account Type 2", "Account Type 3", 
                        "Account Type 4" };

extern BOOL bHELP;

//******************************************************************************
//******************************************************************************
LPSTR GetHostName (int nI)
{
  if (lpHostCfg==NULL) return NULL;
  if (nI>=nCfgNum) return NULL;
  return lpHostCfg[nI].szHostName;
}

char szTmpHostType[40];

//******************************************************************************
//******************************************************************************
LPSTR GetHostType (int nI)
{
  char szSection[200];
  int nType;
  
  if (lpHostCfg==NULL) return NULL;
  if (nI>=nCfgNum) return NULL;
  wsprintf (szSection, "%s:%s", lpApp, lpHostCfg[nI].szConfig);
  GetPrivateProfileString (szSection, szProfHostType, NULL, szTmpHostType, 29, szIniFile);
  if (!isdigit (szTmpHostType[0])) return (LPSTR) szTmpHostType;
  nType = atoi (szTmpHostType); 
  if (nType==LB_ERR) nType = HOST_AUTO;
  return lpHostTypes[nType];
}

//******************************************************************************
//******************************************************************************
LPSTR GetHostTypeValue (int nI)
{
  if (nI>=nHostTypes) return NULL;
  return lpHostTypes[nI];
}

//******************************************************************************
// this encryption is not secure nor is it intended to be
// this is just to keep the password from being plain text
// in the ini file.  I'd really recommend people don't save
// their passwords
//******************************************************************************
LPSTR EnCrypt(LPSTR userid,LPSTR passwd)
{
  int nIndex;
  if(lstrcmp(userid,szAnony)==0)
    return(passwd);
  szCrypt[0]=0;
  for(nIndex=0;nIndex<lstrlen(passwd);nIndex++) 
  {
    wsprintf(&szCrypt[nIndex*2],"%02X",
      ((char)passwd[nIndex])+nIndex);
  }
  return(szCrypt);
}

//******************************************************************************
//******************************************************************************
int unhex(char c) 
{
  if(c>'9') return(c-'7');
  return (c-'0');
}

//******************************************************************************
//******************************************************************************
LPSTR DeCrypt(LPSTR userid,LPSTR passwd)
{
  int nIndex;
  if(lstrcmp(userid,szAnony)==0)
    return(passwd);
  szCrypt[0]=0;
  for(nIndex=0;nIndex<lstrlen(passwd);nIndex+=2) 
  {
    (BYTE)szCrypt[nIndex/2]=
      ((unhex(passwd[nIndex])*16)+
       unhex(passwd[nIndex+1]))-(nIndex/2);
    szCrypt[nIndex/2+1]=0;
  }
  return(szCrypt);
}

//******************************************************************************
//******************************************************************************
void InitConfigLists (HWND hDlg)
{
  LRESULT nI;
  int nIndex;

  SendDlgItemMessage (hDlg,DLG_EDT_CONFIG, CB_RESETCONTENT, 0, 0L);
  SendDlgItemMessage (hDlg,DLG_EDT_HOST,   CB_RESETCONTENT, 0, 0L);
  if (nCfgNum==0) return;
  for (nIndex=0; nIndex<nCfgNum; nIndex++)
  {
    if (lpHostCfg[nIndex].szConfig[0]!=0)
       SendDlgItemMessage (hDlg, DLG_EDT_CONFIG, CB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpHostCfg[nIndex].szConfig);
    if (lpHostCfg[nIndex].szHostName[0]!=0)
    {
      nI = SendDlgItemMessage (hDlg, DLG_EDT_HOST, CB_FINDSTRINGEXACT, (WPARAM) -1, (LPARAM)(LPCSTR) lpHostCfg[nIndex].szHostName);
      if (nI==CB_ERR) SendDlgItemMessage (hDlg,DLG_EDT_HOST,CB_ADDSTRING,0,(LPARAM)(LPCSTR) lpHostCfg[nIndex].szHostName);
    }
  }
  SendDlgItemMessage (hDlg, DLG_EDT_CONFIG, WM_SETTEXT, 0, (LPARAM) (LPCSTR) szConfig);
  SendDlgItemMessage (hDlg, DLG_EDT_HOST,   WM_SETTEXT, 0, (LPARAM) (LPCSTR) szRemoteHost);
  for (nI=0; nI<5; nI++)
  {
    SendDlgItemMessage (hDlg, DLG_ACCOUNTTYPE, CB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpAcctTypes[nI]);
  }
  SendDlgItemMessage (hDlg, DLG_ACCOUNTTYPE, CB_SELECTSTRING, 0, (LPARAM)(LPCSTR) lpAcctTypes[nAcctType]);
}

//******************************************************************************
//******************************************************************************
SetDefaultDlgStuff(HWND hDlg, int nIndex) 
{
  char szSection[80], szHostType[30], szFireWall[10];
  HOSTINFO Host;
  
  wsprintf (szSection, "%s:%s", lpApp, lpHostCfg[nIndex].szConfig);
  memset (&Host, '\0', sizeof (HOSTINFO));
  memset (szHostType, '\0', 30);
  memset (szFireWall, '\0', 10);
  GetPrivateProfileString (szSection, szProfUserID,   NULL, Host.szUserID,   79, szIniFile);
  GetPrivateProfileString (szSection, szProfPass,     NULL, Host.szPassword, 79, szIniFile);
  GetPrivateProfileString (szSection, szProfDir,      NULL, Host.szInitDir,  79, szIniFile);
  GetPrivateProfileString (szSection, szProfScript,   NULL, Host.szScript,   79, szIniFile);
  GetPrivateProfileString (szSection, szProfHostType, NULL, szHostType,      29, szIniFile);
  GetPrivateProfileString (szSection, szProfFireWall, NULL, szFireWall,       9, szIniFile);

  Host.nTimeOut = GetPrivateProfileInt (szSection, szProfTimeOut,  65, szIniFile);
  Host.bSaveDir = GetPrivateProfileInt (szSection, szProfSaveDir,   0, szIniFile);
  Host.bFireWall= (lstrcmpi (szFireWall, "Yes")==0)||(lstrcmp (szFireWall, "1")==0);
  switch (isdigit (szHostType[0]))
  {
    case 0 : Host.nType = GET_CBOX_INDEX (hDlg, DLG_HOST_CBHOSTTYPE, szHostType); break;
    default: Host.nType = atoi (szHostType); 
  }
  if (Host.nType==LB_ERR) Host.nType = HOST_AUTO;
  Host.nType = __max (HOST_AUTO, __min (Host.nType, (nHostTypes-1)));
  
  SetDlgItemText (hDlg, DLG_EDT_SCRIPT, Host.szScript);
  SetDlgItemText (hDlg, DLG_EDT_USERID, (Host.szUserID[0]!='\0')?Host.szUserID:szUserID);
  SetDlgItemText (hDlg, DLG_EDT_PASSWD, DeCrypt (Host.szUserID, Host.szPassword));
  GET_CBOX_INDEX (hDlg, DLG_HOST_CBHOSTTYPE, lpHostTypes[Host.nType]);
  
  CheckDlgButton (hDlg, DLG_HOST_SAVEDIR, Host.bSaveDir);
  CheckDlgButton (hDlg, DLG_HOST_FIREWALL, Host.bFireWall);
  SetDlgItemText (hDlg, DLG_HOST_DIR, Host.szInitDir);
  SetDlgItemInt  (hDlg, DLG_HOST_TIMEOUT, Host.nTimeOut, FALSE);
  return 0;
}

//******************************************************************************
//******************************************************************************
SetDefaultHostStuff (HWND hDlg,LPSTR szRHost) 
{
  int nIndex;

  if (nCfgNum<=0) return FALSE;
  for (nIndex=0; nIndex<nCfgNum; nIndex++)
  {
    if(lstrcmp (szRHost, lpHostCfg[nIndex].szHostName)==0) 
    {
      SetDlgItemText (hDlg, DLG_EDT_CONFIG, lpHostCfg[nIndex].szConfig);
      SetDefaultDlgStuff (hDlg, nIndex);
      break;
    }
  }
  return TRUE;
}

//******************************************************************************
//******************************************************************************
SetDefaultConfigStuff (HWND hDlg, LPSTR szConfig) 
{
  int nIndex;

  if (nCfgNum<=0) return FALSE;
  for (nIndex=0; nIndex<nCfgNum; nIndex++)
  {
    if(lstrcmp (szConfig, lpHostCfg[nIndex].szConfig)==0) 
    {
      SetDlgItemText (hDlg,DLG_EDT_HOST, lpHostCfg[nIndex].szHostName);
      SetDefaultDlgStuff (hDlg, nIndex);
    }
  }
  return TRUE;
}

//********************************************************************
//********************************************************************
void WriteConfig (int nIndex)
{
  char szSection[100];
  
  wsprintf (szString, "CFG%d", nIndex);
  WritePrivateProfileString (lpApp, szString, szConfig, szIniFile);

  wsprintf (szSection, "%s:%s", lpApp, szConfig);
  WritePrivateProfileString (szSection, szProfHostName, szRemoteHost, szIniFile);
  if (szUserID[0]!=0) 
  {
    WritePrivateProfileString (szSection, szProfUserID, szUserID, szIniFile);
    if (szPassWord[0]!=0) 
    {
      WritePrivateProfileString (szSection, szProfPass, EnCrypt (szUserID, szPassWord), szIniFile);
    }
  }
  WritePrivateProfileString (szSection, szProfDir,      szInitDir, szIniFile);
  WritePrivateProfileString (szSection, szProfScript,   szScript,  szIniFile);
  WritePrivateProfileString (szSection, szProfFireWall, bFireWall?"Yes":"No",  szIniFile);
  WritePrivateProfileString (szSection, szProfHostType, lpHostTypes[nHostType], szIniFile);

  wsprintf (szMsgBuf, "%u", uiTimeOut / 1000);
  WritePrivateProfileString (szSection, szProfTimeOut, szMsgBuf, szIniFile);
  WritePrivateProfileString (szSection, szProfSaveDir, bSaveDir?"1":"0", szIniFile);
}

//********************************************************************
//  Set the Transfer type for View operations
//********************************************************************
void SetViewTyp (int nI, char nTyp)
{
  if (nI>=nViewNum) return;
  if (lpViewer==NULL) return;
  lpViewer[nI].nTyp = nTyp;
}

//********************************************************************
//  Return a Transfer type 
//********************************************************************
char GetViewTyp (int nI)
{
  if (nI>=nViewNum) return TYPE_A;
  if (lpViewer==NULL) return TYPE_A;
  return lpViewer[nI].nTyp;
}

//********************************************************************
//  Return a pointer to Extension 
//********************************************************************
LPSTR lpVuExt (int nI)
{
  if (nI>=nViewNum) return (LPSTR) "";
  if (lpViewer==NULL) return (LPSTR) NULL;
  return lpViewer[nI].szExt;
}

//********************************************************************
//  Return a pointer to Viewer
//********************************************************************
LPSTR lpVuPgm (int nI)
{
  if (nI>=nViewNum) return (LPSTR) "";
  if (lpViewer==NULL) return (LPSTR) szViewer;
  return lpViewer[nI].szViewer;
}

//********************************************************************
//  Return a pointer to Directory
//********************************************************************
LPSTR lpVuDir (int nI)
{
  if (nI>=nViewNum) return (LPSTR) NULL;
  if (lpViewer==NULL) return NULL;
  return lpViewer[nI].szDir;
}

//********************************************************************
//  ReAllocate the viewer specs buffer
//********************************************************************
LPSTR ReAllocViewer (int nNum)
{
  LPSTR lpVu;

  if (lpViewer==NULL)
    lpVu = (LPSTR) GlobalAllocPtr (GHND, nNum*sizeof (VIEWERCFG));
  else
    lpVu = (LPSTR) GlobalReAllocPtr (lpViewer, nNum*sizeof (VIEWERCFG), GHND);
  if (lpVu==NULL) return NULL;
  lpViewer = (LPVIEWERCFG) lpVu;
  return lpVu;
}

//********************************************************************
//  Convert type to string
//********************************************************************
LPSTR XferTypToStr (int nVal)
{
  switch (nVal)
  {
    case TYPE_I : return "I";
    case TYPE_A : return "A";
    default     : return "A";
  }
  return "A";
}

//********************************************************************
//  Read the Viewer Definitions
//********************************************************************
void ReadViewerInfo()
{
  char szSection[30], szBuf[160], *lp;
  int nIndex, nLast;

  nViewNum  =GetPrivateProfileInt (lpApp, szProfViewCount, 0, szIniFile);
  if (nViewNum==0) { lpViewer=NULL; return; };
  nViewNum = __max (nViewNum, 20);
  lpViewer  = (LPVIEWERCFG) GlobalAllocPtr (GHND, nViewNum * sizeof (VIEWERCFG));
  wsprintf (szSection, "%s:%s", lpApp, szProfViewer);
  for (nIndex=0; nIndex<nViewNum; nIndex++) 
  {
    wsprintf (szString,"%s%u", szProfViewPgm, nIndex+1);
    GetPrivateProfileString (szSection, szString, NULL, szBuf, 155, szIniFile);
    lpViewer[nIndex].nTyp = szBuf[0]=='I' ?TYPE_I:TYPE_A;
    lp = strtok (szBuf+1, ",");
    if (lp!=NULL) lstrcpy (lpViewer[nIndex].szExt, lp), 
                  strupr (lpViewer[nIndex].szExt);
    lp = strtok (NULL, ",");
    if (lp!=NULL) lstrcpy (lpViewer[nIndex].szViewer, lp);
    lp = strtok (NULL, ",");
    if (lp!=NULL) lstrcpy (lpViewer[nIndex].szDir, lp);
    if (lstrlen (lpViewer[nIndex].szViewer)>0) nLast=nIndex+1;
  }
  nViewNum = nLast;
}

//********************************************************************
//  Save the Viewer Definitions
//********************************************************************
void SaveViewerInfo()
{
  char szSection[30], szBuf[30];
  int nIndex, nNum=1;
  LPSTR lp1, lp2;
  
  if (nViewNum==0) return;
  wsprintf (szSection, "%d", nViewNum);
  WritePrivateProfileString (lpApp, szProfViewCount, szSection, szIniFile);
  wsprintf (szSection, "%s:%s", lpApp, szProfViewer);
  for (nIndex=0; nIndex<nViewNum; nIndex++) 
  {
    lp1 = lpVuExt (nIndex);
    lp2 = lpVuPgm (nIndex);
    if ((lstrlen (lp1)>0) && (lstrlen (lp2)>0))
    {
      wsprintf (szBuf,"%s%u", szProfViewPgm, nNum++);
      wsprintf (szString, "%s,%s,%s,%s", XferTypToStr (lpViewer[nIndex].nTyp), 
                 lpViewer[nIndex].szExt, lpViewer[nIndex].szViewer, 
                 lpViewer[nIndex].szDir);
      WritePrivateProfileString (szSection, szBuf, szString, szIniFile);
    }
  }
}

//********************************************************************
//  Load the User Info from the .ini file
//********************************************************************
void LoadUserInfo()
{
  char szSection[100];
  char szLogFlag[10];
  UINT flags;
  int nIndex;

  GetPrivateProfileString (lpApp, szProfConfig,   "Cica.indiana", szConfig, 79, szIniFile);
  GetPrivateProfileString (lpApp, szProfHostName, "ftp.cica.indiana.edu", szRemoteHost, 79, szIniFile);
  GetPrivateProfileString (lpApp, szProfUserID,   "anonymous", szUserID, 80, szIniFile);
  GetPrivateProfileString (lpApp, szProfMailAddr, NULL, szMailAddress, 127, szIniFile);
  GetPrivateProfileString (lpApp, szProfViewer,   "notepad", szViewer, 120, szIniFile);
  GetPrivateProfileString (lpApp, szProfTempDir,  "C:\\", szTempDir, 80, szIniFile);
  GetPrivateProfileString (lpApp, szProfLogFile,  "C:\\WINFTP.LOG", szLogFile, _MAX_PATH, szIniFile);
  GetPrivateProfileString (lpApp, szProfLogFlag,  "Off", szLogFlag, 5, szIniFile);

  GetPrivateProfileString (lpApp, szProfFireWallHost,  "", szFireWallHost, 80, szIniFile);
  GetPrivateProfileString (lpApp, szProfFireWallUser,  "", szFireWallUserID, 30, szIniFile);
  GetPrivateProfileString (lpApp, szProfFireWallPass,  "", szFireWallUserPass, 30, szIniFile);
  lstrcpy (szFireWallUserPass, DeCrypt (szFireWallUserID, szFireWallUserPass));
  
  bAutoStart= GetPrivateProfileInt (lpApp, szProfAutoStart, bAutoStart, szIniFile);
  bRetain   = GetPrivateProfileInt (lpApp, szProfRetain, 0, szIniFile);
  bDblClkVu = GetPrivateProfileInt (lpApp, szProfDblClk, 0, szIniFile);
  nCfgNum   = GetPrivateProfileInt (lpApp, szProfConfigNum, MAXHOSTS, szIniFile);
  nCfgNum   = __max (nCfgNum, MAXHOSTS);
  nLogFlag  = (lstrcmpi (szLogFlag, "Off")==0) ? MF_UNCHECKED : MF_CHECKED;

  flags=GetPrivateProfileInt(lpApp, szProfFlags, 64+4+1, szIniFile);
  if(flags & 1) bRecvUniq=1; else bRecvUniq=0;
  if(flags & 2) bStorUniq=1; else bStorUniq=2;
  if(flags & 4) bBell=1; else bBell=0;
  if(flags & 8) bInteractive=1; else bInteractive=0;
  if(flags & 16) bVerbose=1; else bVerbose=0;
  if(flags & 32) bHash=1; else bHash=2;
//if(flags & 64) bSendPort=1; else bSendPort=0;
  if(flags & 128) bDoGlob=1; else bDoGlob=2;
  
  CreateTempFileNames (szTempDir);
  
  lpHostCfg = (LPHOSTCONFIG) GlobalAllocPtr (GHND, nCfgNum * sizeof (HOSTCONFIG));
  for (nIndex=0; nIndex<nCfgNum; nIndex++) 
  {
    wsprintf (szString,"CFG%u", nIndex);
    GetPrivateProfileString (lpApp, szString, NULL, lpHostCfg[nIndex].szConfig, 79, szIniFile);
  }
  ReadViewerInfo();
  for (nIndex=0; nIndex<nCfgNum; nIndex++) 
  {
    if (lpHostCfg[nIndex].szConfig[0]!='\0')
    {
      wsprintf (szSection,"%s:%s", lpApp, lpHostCfg[nIndex].szConfig);
      GetPrivateProfileString (szSection, szProfHostName, NULL, lpHostCfg[nIndex].szHostName, 79, szIniFile);
    } 
  }
}

//********************************************************************
//  Save the User Info to the .ini file
//********************************************************************
void SaveUserInfo()
{
  UINT flags;
  int nIndex;

  flags=((bRecvUniq==1)?1:0) +
//              ((bStorUniq==1)?2:0) +
                ((bBell==1)?4:0) +
                ((bInteractive==1)?8:0)+
//              ((bHash==1)?32:0) +
//              ((bSendPort==1)?64:0) +
//              ((bDoGlob==1)?128:0) +
                ((bVerbose==1)?16:0);
 
  if (lstrlen (szFireWallHost)>0)
    lstrcpy (szFireWallUserPass, EnCrypt (szFireWallUserID, szFireWallUserPass));

  WritePrivateProfileString (lpApp, szProfConfig,   szConfig,     szIniFile);
  WritePrivateProfileString (lpApp, szProfHostName, szRemoteHost, szIniFile);
  WritePrivateProfileString (lpApp, szProfUserID,   szUserID,     szIniFile);
  WritePrivateProfileString (lpApp, szProfMailAddr, szMailAddress,szIniFile);
  WritePrivateProfileString (lpApp, szProfViewer,   szViewer,     szIniFile);
  WritePrivateProfileString (lpApp, szProfTempDir,  szTempDir,    szIniFile);
  WritePrivateProfileString (lpApp, szProfLogFile,  szLogFile,    szIniFile);
  
  WritePrivateProfileString (lpApp, szProfFireWallHost, szFireWallHost,     szIniFile);
  WritePrivateProfileString (lpApp, szProfFireWallUser, szFireWallUserID,   szIniFile);
  WritePrivateProfileString (lpApp, szProfFireWallPass, szFireWallUserPass, szIniFile);

  WritePrivateProfileString(lpApp, szProfLogFlag,  (nLogFlag==MF_UNCHECKED)?"Off":"On", szIniFile);
  wsprintf(szString,"%u",bAutoStart);
  WritePrivateProfileString(lpApp, szProfAutoStart,szString,    szIniFile);
  wsprintf(szString,"%u",bDblClkVu);
  WritePrivateProfileString(lpApp, szProfDblClk,   szString,    szIniFile);
  wsprintf (szString,"%d",nCfgNum);
  WritePrivateProfileString (lpApp,szProfConfigNum, szString, szIniFile);
  wsprintf (szString,"%d",bRetain);
  WritePrivateProfileString (lpApp,szProfRetain, szString, szIniFile);
  wsprintf (szString,"%u",flags);
  WritePrivateProfileString (lpApp,szProfFlags, szString, szIniFile);
  for (nIndex=0; nIndex<nCfgNum; nIndex++)
  {
    if (lpHostCfg[nIndex].szHostName[0]!=0) 
    {
      wsprintf (szString, "CFG%u", nIndex);
      WritePrivateProfileString (lpApp, szString, lpHostCfg[nIndex].szConfig, szIniFile);
    }
  }
  SaveViewerInfo();

  GlobalFreePtr (lpViewer);
  GlobalFreePtr (lpHostCfg);
}

//******************************************************************************
// Update an Existing Configuration
//******************************************************************************
UpdateConfig (int nIndex)
{
  if (nIndex>=nCfgNum) return -1;
  WriteConfig (nIndex);
  return 0;
}

//******************************************************************************
// Add a New Configuration to the Config List
//******************************************************************************
void ClearConfig (int nIndex)
{
  char szSection[100];
  HOSTINFO Host;
  
  wsprintf (szString,"CFG%u", nIndex);
  wsprintf (szSection,"%s:%s", lpApp, lpHostCfg[nIndex].szConfig);
  memset (lpHostCfg+nIndex, '\0', sizeof (HOSTCONFIG));
  memset (&Host, '\0', sizeof (HOSTINFO));
  WritePrivateProfileString (lpApp,     szString,       Host.szConfig,   szIniFile);
  WritePrivateProfileString (szSection, szProfHostName, Host.szHostName, szIniFile);
  WritePrivateProfileString (szSection, szProfUserID,   Host.szUserID,   szIniFile);
  WritePrivateProfileString (szSection, szProfPass,     Host.szPassword, szIniFile);
  WritePrivateProfileString (szSection, szProfDir,      Host.szInitDir,  szIniFile);
  WritePrivateProfileString (szSection, szProfHostType,  "0",  szIniFile);
  WritePrivateProfileString (szSection, szProfTimeOut,  "65",  szIniFile);
}

//******************************************************************************
// Add a New Configuration to the Config List
//******************************************************************************
AddNewConfig()
{
  int nIndex;
  LPHOSTCONFIG lpHost;
  
  for (nIndex=0; nIndex<nCfgNum; nIndex++)
  {
    if (lpHostCfg[nIndex].szConfig[0]=='\0') break;
  }
  if (nIndex==nCfgNum)
  {
    lpHost = (LPHOSTCONFIG) GlobalReAllocPtr (lpHostCfg, (nCfgNum+5)*sizeof (HOSTCONFIG), GHND);
    if (lpHost==NULL) return -1;
    else lpHostCfg = lpHost, nCfgNum+=5;
  }
  if (szConfig[0]=='\0') wsprintf (szConfig, "Cfg.%s", szRemoteHost);
  UpdateConfig (nIndex);
  return 0;
}

//******************************************************************************
// Given a Config Name, find its index
//******************************************************************************
int FindConfig (LPSTR lpConfig, BOOL bCase)
{
  int nIndex;

  for (nIndex=0; nIndex<nCfgNum; nIndex++)
  {
    switch (bCase)
    {
      case TRUE : if (lstrcmp  (lpHostCfg[nIndex].szConfig, lpConfig)==0) return nIndex; break;
      case FALSE: if (lstrcmpi (lpHostCfg[nIndex].szConfig, lpConfig)==0) return nIndex;
    }
  }
  return -1;
}

//******************************************************************************
//  Retrieve the directories associated with the configuration
//******************************************************************************
RetrieveDirList (HWND hWnd)
{
	char szCfgBuf[100];
	char szDir[100], szDirSpec[10];
	int nI=0, nLen;
	
	int nIndex = FindConfig (szConfig, TRUE);
	if (nIndex==-1) return 0;
	if (lstrcmpi (szRemoteHost, lpHostCfg[nIndex].szHostName)!=0) return 0;
	if (!bSaveDir) return 0;
	wsprintf (szCfgBuf, "%s:%s", lpApp, szConfig);
	do
	{
		wsprintf (szDirSpec, "DIR%d", ++nI);
    GetPrivateProfileString (szCfgBuf, szDirSpec, "", szDir, 95, szIniFile);
    nLen=lstrlen (szDir);
    if ((nLen>0) && (lstrcmp (szDir, szUndecipher)!=0))
    {
      SendDlgItemMessage (hWnd, LST_RDIRLST, CB_ADDSTRING, (WPARAM) 0, (LPARAM)(LPCSTR) szDir);
    }
	}
	while (nLen>0);
	return 0;
}

//******************************************************************************
//  Retrieve the directories associated with the configuration
//******************************************************************************
SaveDirList (HWND hWnd)
{
	char szCfgBuf[100];
	char szDir[100], szDirSpec[10];
	int nI=0, nJ, nMax;
	
	int nIndex = FindConfig (szConfig, TRUE);
	if (nIndex==-1) return 0;
	if (lstrcmpi (szRemoteHost, lpHostCfg[nIndex].szHostName)!=0) return 0;
	if (!bSaveDir) return 0;
	nMax = (int) SendDlgItemMessage (hWnd, LST_RDIRLST, CB_GETCOUNT, (WPARAM) 0, (LPARAM) 0);
	if (nMax==0) return 0;
	wsprintf (szCfgBuf, "%s:%s", lpApp, szConfig);
	for (nI=0, nJ=1; nI<nMax; nI++)
	{
    SendDlgItemMessage (hWnd, LST_RDIRLST, CB_GETLBTEXT, (WPARAM) nI, (LPARAM)(LPCSTR) szDir);
    if (lstrcmp (szDir, szUndecipher)!=0)
    {
  		wsprintf (szDirSpec, "DIR%d", nJ++);
      WritePrivateProfileString (szCfgBuf, szDirSpec, szDir, szIniFile);
    }
	}
	return 0;
}

//******************************************************************************
//  Retrieve the directories associated with the configuration
//******************************************************************************
UpdateDirListOpt (HWND hWnd, BOOL bOpt)
{
  bSaveDir = bOpt;
	return 0;
}

//******************************************************************************
//******************************************************************************
int RetrieveConfig (HWND hDlg, BOOL bFlag)
{
  int nRC=0;
  BOOL bXlat;

  memset (szScript, '\0', 5);
  memset (szAccountPass, '\0', 5);
  GetDlgItemText (hDlg, DLG_EDT_CONFIG, szConfig, 70);
  GetDlgItemText (hDlg, DLG_EDT_HOST, szRemoteHost, 70);
  GetDlgItemText (hDlg, DLG_EDT_USERID, szUserID, 15);
  GetDlgItemText (hDlg, DLG_EDT_PASSWD, szPassWord, 50);
  GetDlgItemText (hDlg, DLG_EDT_ACCOUNT, szAccountPass, 30);
  GetDlgItemText (hDlg, DLG_EDT_SCRIPT, szScript, _MAX_PATH);
  GetDlgItemText (hDlg, DLG_HOST_DIR, szInitDir, _MAX_PATH);
  nRC = GetDlgItemInt (hDlg, DLG_HOST_TIMEOUT, &bXlat, FALSE);
  if (!bXlat) nRC = 0; nRC = __min (nRC, 65);
  uiTimeOut = ((nRC==0) ? 65 : (UINT) nRC ) * 1000;
  bSavePWD = bFlag | IsDlgButtonChecked (hDlg,DLG_HOST_PASSWORD);
  bSaveDir = IsDlgButtonChecked (hDlg,DLG_HOST_SAVEDIR);
  bFireWall= IsDlgButtonChecked (hDlg,DLG_HOST_FIREWALL);
  bAccount = (lstrlen (szAccountPass) > 0);
  nAcctType = (int) SendDlgItemMessage (hDlg, DLG_ACCOUNTTYPE, CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0);
  nHostType = (int) SendDlgItemMessage (hDlg, DLG_HOST_CBHOSTTYPE, CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0);
  if ((!bAccount)||(nAcctType>4)) nAcctType = 0;
  return 0;
}

//******************************************************************************
//******************************************************************************
ProcessConfig (HWND hDlg)
{
  int nIndex = FindConfig (szConfig, TRUE);
  switch (nIndex)
  {
    case -1: AddNewConfig(); break;
    default: UpdateConfig (nIndex); break;
  }
  return 0;
}

//******************************************************************************
//******************************************************************************
BOOL OnCmdDeleteHostConfig (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  int nIndex;
  char szConfig[80];

  GetDlgItemText (hDlg, DLG_EDT_CONFIG, szConfig, 70);
  nIndex = FindConfig (szConfig, TRUE);
  if (nIndex!=-1) ClearConfig (nIndex);
  memset (szConfig, '\0', sizeof (szConfig));
  SetDlgItemText (hDlg, DLG_EDT_CONFIG, szConfig);
  SetDlgItemText (hDlg, DLG_EDT_HOST,   szConfig);
  SetDlgItemText (hDlg, DLG_EDT_USERID, szConfig);
  SetDlgItemText (hDlg, DLG_EDT_PASSWD, szConfig);
  SetDlgItemText (hDlg, DLG_HOST_DIR,   szConfig);
  SetDlgItemInt (hDlg, DLG_HOST_TIMEOUT, uiTimeOut/1000, FALSE);
  InitConfigLists (hDlg);
  return TRUE;
}

//******************************************************************************
//******************************************************************************
BOOL OnDlgHostInit (HWND hDlg)
{
  int nIndex;
  
  SendDlgItemMessage (hDlg, DLG_HOST_CBHOSTTYPE, CB_RESETCONTENT, (WPARAM) 0, (LPARAM) 0);
  for (nIndex=0; nIndex<nHostTypes; nIndex++)
  {
    SendDlgItemMessage (hDlg, DLG_HOST_CBHOSTTYPE, CB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpHostTypes[nIndex]);
  }
  InitConfigLists (hDlg);
  SetDlgItemText (hDlg, DLG_EDT_CONFIG, szConfig);
  SetDlgItemText (hDlg, DLG_EDT_HOST, szRemoteHost);
  SetDlgItemText (hDlg, DLG_EDT_USERID, szUserID);
  SetDlgItemText (hDlg, DLG_EDT_PASSWD, szPassWord);
  SetDlgItemText (hDlg, DLG_HOST_DIR, szInitDir);
  SetDlgItemInt  (hDlg, DLG_HOST_TIMEOUT, uiTimeOut/1000, FALSE);
  CheckDlgButton (hDlg, DLG_HOST_SAVEDIR, bSaveDir);
  CheckDlgButton (hDlg, DLG_HOST_FIREWALL, bFireWall);
  CheckDlgButton (hDlg, DLG_HOST_PASSWORD, FALSE);
  if (lstrlen (szConfig)>0) SetDefaultConfigStuff (hDlg, szConfig);
  else if (lstrlen (szRemoteHost)>0) SetDefaultHostStuff (hDlg, szRemoteHost);
  SendDlgItemMessage (hDlg, DLG_EDT_HOST, WM_SETREDRAW, TRUE, 0l);
  return TRUE;
}

//******************************************************************************
//******************************************************************************
BOOL OnCmdEditConfig (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  int nIndex;

  switch (wNotifyCode)
  {
    case CBN_KILLFOCUS :
    case CBN_EDITCHANGE: GetDlgItemText (hDlg, DLG_EDT_CONFIG, szConfig, 70);
                         SetDefaultConfigStuff (hDlg, szConfig);
                         return TRUE;
    case CBN_SELCHANGE : if ((nIndex=(int) SendDlgItemMessage (hDlg, DLG_EDT_CONFIG, CB_GETCURSEL, 0, 0L))!=LB_ERR)
                         {
                           SendDlgItemMessage (hDlg, DLG_EDT_CONFIG, CB_GETLBTEXT, nIndex, (LPARAM)(LPCSTR) szConfig);
                           SetDefaultConfigStuff (hDlg, szConfig);
                           return TRUE;
                         }
  }
  return FALSE;
}

//******************************************************************************
//******************************************************************************
BOOL OnCmdAnonymous (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  SetDlgItemText (hDlg, DLG_EDT_USERID, szAnony);
  SetDlgItemText (hDlg, DLG_EDT_PASSWD, szMailAddress);
  return TRUE;
}

//******************************************************************************
//******************************************************************************
BOOL OnCmdPassword (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  if (!IsDlgButtonChecked (hDlg, DLG_HOST_SAVE))
     CheckDlgButton (hDlg, DLG_HOST_PASSWORD, FALSE);
  return(FALSE);
}

//******************************************************************************
//******************************************************************************
BOOL OnCmdSaveHostConfig (HWND hDlg, WORD wCtlID, WORD wNotifyCode)
{
  RetrieveConfig (hDlg, TRUE);
  ProcessConfig (hDlg);
  InitConfigLists (hDlg);
  return TRUE;
}

//******************************************************************************
//******************************************************************************
BOOL FAR PASCAL WS_HostMsgProc (HWND hDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG: return OnDlgHostInit (hDlg);
    case WM_CLOSE     : PostMessage(hDlg, WM_COMMAND, IDCANCEL, 0L); break;
    case WM_COMMAND:
    {
#ifdef WIN32
      WORD wCtlID =  LOWORD (wParam);
      WORD wNotifyCode = HIWORD(wParam);
#else
      WORD wCtlID =  wParam;
      WORD wNotifyCode = HIWORD(lParam);
#endif
      
      switch (wCtlID)
      {
        case DLG_EDT_CONFIG   : return OnCmdEditConfig (hDlg, wCtlID, wNotifyCode); 
        case DLG_HOST_ANONY   : return OnCmdAnonymous (hDlg, wCtlID, wNotifyCode);
        case DLG_HOST_PASSWORD: return OnCmdPassword (hDlg, wCtlID, wNotifyCode);
        case IDC_DELCFG       : return OnCmdDeleteHostConfig (hDlg, wCtlID, wNotifyCode);
        case IDC_SAVCFG       : return OnCmdSaveHostConfig (hDlg, wCtlID, wNotifyCode);
        case IDOK             : RetrieveConfig (hDlg, FALSE);
                                EndDialog (hDlg, TRUE); return TRUE;
        case IDCANCEL         : EndDialog(hDlg, FALSE); return TRUE;
        default               : return FALSE;
      }
    }
    return TRUE;
    default: return FALSE;
  }
  return TRUE;
}

//********************************************************************
//  Create a local Name for the file
//********************************************************************
MakeLocalName (LPSTR localname, LPSTR remotename)
{
  int nIndex;
  char szRemote[_MAX_PATH], *lpRemote;
  char szName[10], Ext[4], *s;

  //**********************************************************
  // Scan past leading periods in string
  //  Copy at most eight characters to szName
  //**********************************************************
  
  lstrcpy (szRemote, remotename); 
  lpRemote=szRemote;
  if ((s=strchr (szRemote, ';'))!=NULL) *s='\0';
  while (*lpRemote!=0 && *lpRemote=='.') lpRemote++;
  for (nIndex=0; nIndex<8; nIndex++)
  {
    if (*lpRemote!=0 && *lpRemote!='.' && *lpRemote!=' ') szName[nIndex] = *lpRemote++;
    else break;
  }

  szName[nIndex]=0; 
  Ext[0]=0;
  
  //**********************************************************
  // Check if there are any second level names
  //**********************************************************
  if ((s=strchr(lpRemote,'.'))!=NULL) lpRemote=s;
  
  //**********************************************************
  //  Scan past blanks or periods
  //  Copy the next three characters at most to Extension
  //**********************************************************
  while ((*lpRemote!=0) && (*lpRemote=='.' || *lpRemote==' ')) lpRemote++;
  if (*lpRemote!=0) 
  {
    for (nIndex=0; nIndex<3; nIndex++)
    {
      if (*lpRemote!=0) Ext[nIndex] = *lpRemote++;
      else break;
    }
    Ext[nIndex]=0;
  }
  
  //**********************************************************
  //  Create the full local name of the local file
  //**********************************************************
  if (Ext[0]==0) lstrcpy (localname, szName);
  else wsprintf (localname,"%s.%s",szName, Ext);

  if (lstrlen (localname)==0) 
  {
    lstrcpy (szName,"aaremote");
    lstrcpy (localname, szName);
  }

  if (bRecvUniq) 
  {
    CreateUniqueName (localname, szName, Ext);
  }
  return(TRUE);
}

//********************************************************************
// used if name is last thing on the line
//********************************************************************
LPSTR FindName(LPSTR szLine)
{
  int nIndex;
  char *pStr;
  static char szTrim[5] = " \r\n\t";
  
  nIndex = lstrlen (szLine);
  
  // strip trailing garbage from the line if there is any.
  while ((nIndex>2) && (strchr (szTrim, szLine[nIndex-1])!=NULL))
    szLine[nIndex--]=0;

  // now the name SHOULD be the last thing on the line
  if((pStr=strrchr(szLine,' '))!=NULL ||
     (pStr=strrchr(szLine,0x09))!=NULL) 
  {
    while(*pStr && (*pStr==' ' || *pStr==0x09)) pStr++;
    return(pStr);
  }
  return(szLine);
}

//********************************************************************
//  Process Dir Line for SuperTCP, Chameleon, NCSA servers
//********************************************************************
void ReadDirLineSuperTCP (LPSTR lpStr)
{
  LPSTR pStr;

  if (strstr (lpStr,"<DIR>")!=NULL) 
  {
    if ((pStr=strchr(lpStr,' '))!=NULL) *pStr=0;
    if (lstrcmp (lpStr,".")!=0 && lstrcmp (lpStr,"..")!=0)
       SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
  } 
  else 
  {
    if ((pStr=strchr (lpStr,' '))!=NULL) *pStr=0;
    if (lpStr[0]!=0)
       SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
  }
}

//********************************************************************
//  Process Dir Line for QVT/Net server
//********************************************************************
void ReadDirLineQVT (LPSTR lpStr)
{
  int nLen = lstrlen (lpStr);
  
  if (lpStr[nLen-1]=='/' || lpStr[nLen-1]=='\\')
  {
    lpStr[nLen-1]=0;
    if (lstrcmp(lpStr,".")!=0 && lstrcmp (lpStr,"..")!=0)
        SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
  } 
  else
  {
    SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
  }
}

//********************************************************************
//  Process Dir Line for IBM VM servers
//********************************************************************
void ReadDirLineIBMVM (LPSTR lpStr)
{
  lpStr[12]=0;
  SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
}

//********************************************************************
//  Process Dir Line for IBM MVS servers
//********************************************************************
void ReadDirLineIBMMVS (LPSTR lpStr)
{
  if (strstr (lpStr, "Lrecl")!=NULL) return;
  if (lstrlen (lpStr+54)>0)
     SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) (lpStr+54));
}

//********************************************************************
//  Process Dir Line for VMS servers
//********************************************************************
void ReadDirLineVMS (LPSTR lpStr)
{
  int nLen = lstrlen (lpStr);
  LPSTR lp, s;

  if (*lpStr==' ') return;
  if ((s=strchr(lpStr,';'))==NULL) return;
                  
  s++; 
  while (isdigit (*s)) s++;
  *s=0;
  if ((nLen>4) && ((lp=strstr (lpStr,".DIR"))!=NULL))
  {
    *lp = 0;
    SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
  } 
  else
  {
    SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
  }
}

//********************************************************************
//  Process Dir Line for PCTCP servers
//********************************************************************
void ReadDirLinePCTCP (LPSTR lpStr)
{
  LPSTR lp;

  lpStr[30]=0; 
  lp=FindName(lpStr);
  if (strncmp (lpStr, "<dir>", 5)==0) 
  {
    if (lstrcmp(lp,".")!=0 && lstrcmp(lp,"..")!=0)
         SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lp);
  } 
  else
  {
    SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LPARAM)(LPCSTR) lp);
  }
}

//********************************************************************
//  Process Dir Line for SuperTCP, Chameleon, NCSA servers
//********************************************************************
void ReadDirLineIBMTCP (LPSTR lpStr)
{
  LPSTR lp;

  lp = FindName (lpStr);
  if (strstr (lpStr," DIR ")!=NULL) 
  {
    if (lstrcmp(lp,".")!=0 && lstrcmp(lp,"..")!=0)
       SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lp);
  } 
  else
  {
    SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lp);
  }
}

//********************************************************************
//  Process Dir Line for SuperTCP, Chameleon, NCSA servers
//********************************************************************
void ReadDirLineNOS (LPSTR lpStr)
{
  LPSTR pStr;
  int nLen, nRC;

  if (strstr (lpStr,"Disk size")!=NULL) return;
             
  nLen=lstrlen (lpStr);
  lpStr[13]=0; 
  nRC=13;
  while (nLen>0 && lpStr[nLen-1]==' ') lpStr[--nLen]=0;
  if (*lpStr!=0) 
  {
    if (lpStr[nLen-1]=='/' || lpStr[nLen-1]=='\\')
    {
      lpStr[nLen-1]=0;
      if (lstrcmp (lpStr,".")!=0)
        SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
    } 
    else
    {
      SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) lpStr);
    }
  }
  pStr=lpStr+41; 
  nRC=13; 
  pStr[nRC]=0;
  while ((nRC=lstrlen(pStr))>0 && pStr[nRC-1]==' ') pStr[nRC-1]=0;
  if (*pStr=='\0') return;

  nLen = lstrlen (pStr);
  if (pStr[nLen-1]=='/' || pStr[nLen-1]=='\\')
  {
    pStr[nLen-1]=0;
    if (lstrcmp (pStr,".")!=0 && lstrcmp (pStr,"..")!=0)
       SendMessage (hLbxRDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) pStr);
  } 
  else
  {
    SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) pStr);
  }
}

//********************************************************************
//  Process Dir Line for SuperTCP, Chameleon, NCSA servers
//********************************************************************
void ReadDirLineUNIX (LPSTR lpStr)
{
  LPSTR pStr;

  // assume UNIX ls format
  // if line starts with 'd' its a directory
  
  pStr = FindName (lpStr);
  if (lpStr[0]=='d')
  {
    if (lstrcmp (pStr,".")!=0 && lstrcmp (pStr,"..")!=0)
      SendMessage(hLbxRDir,LB_ADDSTRING,0,(LPARAM)(LPCSTR) pStr);
  } 
  else if (lpStr[0]=='l')
  {
    SendMessage (hLbxRDir,LB_ADDSTRING,0,(LPARAM)(LPCSTR) pStr);
    SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) pStr);
  } 
  else
  {
    // if line starts with - or f its a file
    if (nHostType==HOST_SINTFTPD || strchr ("-f", lpStr[0])!=NULL) 
    {
      SendMessage (hLbxRFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) pStr);
    }
  }
}

//********************************************************************
//  Get the Remote directory listing
//********************************************************************
int GetRemoteDirForWnd (HWND hWnd)
{
  char *pStr;
  FILE *fd;
  int nRC, nLen;

  //***************************************************************
  // clean out the old contents of the list boxes
  //***************************************************************
  SendMessage (hLbxRDir,   LB_RESETCONTENT, 0, 0);
  SendMessage (hLbxRFiles, LB_RESETCONTENT, 0, 0);

  //***************************************************************
  // can't do much if we aren't connected
  //***************************************************************
  if (!bConnected) 
  {
    SendMessage (hTxtRDir, WM_SETTEXT,0,(LPARAM)(LPCSTR) "");
    if (bHELP) DoAddLine ("Connection Closed"), bHELP = FALSE;
    return 0;
  }

  //***************************************************************
  // For the first time round, do the Help command now to avoid
  // Undecipherable in the Directory window.
  //***************************************************************
  if (!bHELP) ReadProcessHelp (hWnd, ctrl_socket);
  
  //***************************************************************
  // get the remote directory name
  //***************************************************************
  lstrcpy (szString, szUndecipher);
  nRC = DoPWD (ctrl_socket);
  if (nRC==FTP_COMPLETE) 
  {
    if ((pStr=strchr (szMsgBuf,'"'))!=NULL) strncpy (szString,++pStr,180);
    else ConvertSourceDir (szMsgBuf, szString, 100);
    if ((pStr=strchr (szString,'"'))!=NULL) *pStr=0;
    else szString[180]=0;
  }

  //***************************************************************
  // DLG_RDIRECTORY (directory name)
  //***************************************************************
  SendMessage (hTxtRDir, WM_SETTEXT, 0, (LPARAM)(LPCSTR) szString);
  AddDirToList (hWnd, LST_RDIRLST, szString);
  SendDlgItemMessage (hWnd, LST_RDIRLST, CB_SELECTSTRING, (WPARAM) 0, (LPARAM)(LPCSTR) szString);

  //***************************************************************
  // go get the current remote directory listing in tmpfile.tmp
  // get the file type, check for all files, if not, append to the
  // LIST request about to be issued to the remote host
  //***************************************************************
  lstrcpy (szString, "LIST");
  if ((wSortType==IDM_SORTBYDATE) && (nHostType==HOST_UNIX || nHostType==HOST_AUTO))
//  if (wSortType==IDM_SORTBYDATE)
  {
    lstrcat (szString, " -lt");
  }
  nLen = lstrlen (szString);
  szString[nLen++] = '\0';
  SetDebugWindowText ("WinFTP List");
  SendDlgItemMessage (hWnd, EDT_RFILETYPE, WM_GETTEXT, (WPARAM) 80, (LPARAM)(LPCSTR)(szString+nLen));
  if ((lstrlen (szString+nLen)>0) && (lstrcmp (szString+nLen,"*")!=0)) szString[nLen-1] = ' ';
  nRC = DoDirList (ctrl_socket, szString);

  SetDebugWindowText (lpDebugWindow);
  SendMessage (hLbxRDir, LB_ADDSTRING,0, (LPARAM)(LPCSTR) "..");
  if (nRC!=FTP_COMPLETE)
  {
    DoPrintf ("Directory List Error (Code %u)", nRC);
    return 0;
  }

  if ((fd=fopen (szCurrentDir,"r"))==NULL)
  {
    DoAddLine ("Couldn't open TempDirFile for reading.");
    return 0;
  }

  while (fgets (szString,180,fd)!=NULL)
  {
    if ((pStr=strchr (szString,'\n'))!=NULL) *pStr=0;
    switch (nHostType) 
    {
      case HOST_SUPER       : ReadDirLineSuperTCP (szString); break;
      case HOST_CHAMELEON   : ReadDirLineSuperTCP (szString); break;
      case HOST_NCSA        : ReadDirLineSuperTCP (szString); break;
      case HOST_QVT         : ReadDirLineQVT (szString); break;
      case HOST_IBM_VM      : ReadDirLineIBMVM (szString); break;
      case HOST_MVS         : ReadDirLineIBMMVS (szString); break;
      case HOST_VMS_UCX     : ReadDirLineVMS (szString); break;
      case HOST_VMS_MULTINET: ReadDirLineVMS (szString); break;
      case HOST_PCTCP       : ReadDirLinePCTCP (szString); break;
      case HOST_IBM_TCP     : ReadDirLineIBMTCP (szString); break;
      case HOST_NOS         : ReadDirLineNOS (szString); break;
      case HOST_SINTFTPD    : ReadDirLineUNIX (szString); break;
      case HOST_U5000       : ReadDirLineUNIX (szString); break;
      case HOST_UNIX        : ReadDirLineUNIX (szString); break;
      default               : ReadDirLineUNIX (szString); break;
    }
  }
  fclose(fd);
  return 0;
}

extern BOOL bCanMKD,bCanRMD,bCanREN,bCanDELE;

//********************************************************************
//  Show Flag Settings
//********************************************************************
void ShowOurFlags()
{
  DoPrintf("MKD=%u RMD=%u REN=%u DEL=%u HostType=%u",
    bCanMKD,bCanRMD,bCanREN,bCanDELE,nHostType);
}

//********************************************************************
//  Process Help Info
//********************************************************************
int ReadProcessHelp (HWND hWnd, SOCKET ctrl_socket)
{
  int iRetCode;
  BOOL bCanSYST;

  bCanMKD=bCanRMD=bCanREN=bCanDELE=bCanSYST=FALSE;

  if (SendPacket (ctrl_socket,"HELP")!=-1) 
  {
    SetDebugWindowText ("WSFTP Help");
    iRetCode=ReadLine(ctrl_socket);
    if((iRetCode/100)==5 && nHostType==0) nHostType = HOST_NOS;
    else 
    {
      if (nHostType==HOST_AUTO) 
      {
        if (strstr(szMsgBuf,"NCSA")!=NULL || strstr(szMsgBuf,"CUTCP")!=NULL) nHostType=HOST_NCSA;
        else if (strncmp(szMsgBuf,"214-PC FTP server",17)==0 || strstr(szMsgBuf,"QVT")!=NULL)
                nHostType=HOST_QVT;
      }
      while((iRetCode!=421) && ((iRetCode/100)!=2 || szMsgBuf[3]=='-')) 
      {
        if(strstr(szMsgBuf,"MKD")!=NULL) bCanMKD=TRUE;
        if(strstr(szMsgBuf,"RMD")!=NULL) bCanRMD=TRUE;
        if(strstr(szMsgBuf,"RNFR")!=NULL) bCanREN=TRUE;
        if(strstr(szMsgBuf,"DELE")!=NULL) bCanDELE=TRUE;
        if(strstr(szMsgBuf,"SYST")!=NULL) bCanSYST=TRUE;
        iRetCode=ReadLine(ctrl_socket);
      }
    }
  }
  SetButtonEnabledStatus (BTN_RMKDIR, bCanMKD);
  SetButtonEnabledStatus (BTN_RRMDIR, bCanRMD);
  SetButtonEnabledStatus (BTN_RRENAME, bCanREN);
  SetButtonEnabledStatus (BTN_RDELETE, bCanDELE);
  bHELP=TRUE;
  
  if (bCanSYST) DoSystemCommand (ctrl_socket);
  else if (nHostType==HOST_AUTO) nHostType=HOST_UNIX;
  SetDebugWindowText (lpDebugWindow);
  return iRetCode;
}

//************************************************************************
//  Convert Directory name to VMS style directory name
//************************************************************************
ConvertToVMSDir (LPSTR lpDir, int nSiz)
{
  char szTmp[120];

  (lstrcmp (lpDir,"..")!=0) ? ((long) wsprintf (szTmp, "[.%s]", lpDir)) : ((long) lstrcpy (szTmp, "[-]"));
  if (lstrlen (szTmp)<nSiz) lstrcpy (lpDir, szTmp);
  return 0;
}

//************************************************************************
//  Convert Directory name to VMS style directory name
//************************************************************************
ConvertFromVMSDir (LPSTR lpBuf, LPSTR lpDir, int nSiz)
{
  char *lp;

  lp = strstr (lpBuf, ":[");    //  Look for the Disk:[dir] format
  if (lp==NULL) return 0;       //  If not found, nothing can be done
  while ((lp!=lpBuf) && (*lp!=' ')) lp--;
  if (*lp==' ') lp++;

#ifdef WIN32
  lstrcpy (lpDir, lp);
#else
  lstrcpyn (lpDir, lp, nSiz-1);
#endif
  
  lp = strchr (lpDir, ' ');
  if (lp!=NULL) *lp = '\0';
  return 0;
}

//************************************************************************
//  Convert Directory name to VMS style directory name
//************************************************************************
ConvertFromDefaultDir (LPSTR lpBuf, LPSTR lpDir, int nSiz)
{
  LPSTR lp;
  char szBuf[_MAX_PATH];

  lp = strchr (lpBuf, '"');    //  Look for the Disk:[dir] format
  if (lp==NULL) return 0;       //  If not found, nothing can be done
  lp++;
  lstrcpy (szBuf, lp);
  lp = strchr (szBuf, '"');
  if (lp==NULL) return 0;
  *lp = '\0';

#ifdef WIN32
  lstrcpy (lpDir, szBuf);
#else
  lstrcpyn (lpDir, szBuf, nSiz-1);
#endif
  
  lp = strchr (lpDir, ' ');
  if (lp!=NULL) *lp = '\0';
  return 0;
}

//************************************************************************
//  Convert to the appropriate host directory name format
//************************************************************************
ConvertTargetDir (LPSTR lpDir, int nSiz)
{
  switch (nHostType)
  {
    case HOST_VMS_MULTINET:
    case HOST_VMS_UCX     : ConvertToVMSDir (lpDir, nSiz); break;
  }
  return 0;  
}

//************************************************************************
//  Convert to the appropriate host directory name format
//************************************************************************
ConvertSourceDir (LPSTR lpBuf, LPSTR lpDir, int nSiz)
{
  switch (nHostType)
  {
    case HOST_VMS_MULTINET: 
    case HOST_VMS_UCX     : ConvertFromVMSDir (lpBuf, lpDir, nSiz); break;
    default               : ConvertFromDefaultDir (lpBuf, lpDir, nSiz); break;
  }
  return 0;  
}


