/*
  MODULE: WINFTP.H   (main program header file)
*/

#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include "resource.h"

// **** Dialog box names
// #define DLG_ABOUT                 510
// #define DLG_HOST                  520
// #define DLG_INPUT                 530
// #define DLG_STATUS                540

// **** debug window menu definitions
// may be used by other functions!

// under COMMAND popup menu
#define CMD_CONNECT                 1010
#define CMD_CLOSE                   1020

#define CMD_CWD                     1040
#define CMD_DELE                    1050
#define CMD_HELP                    1060
#define CMD_LIST                    1070
#define CMD_MKD                     1080
#define CMD_NLST                    1090
#define CMD_PWD                     1100
#define CMD_QUOTE                   1110
#define CMD_RETR                    1120
#define CMD_RMD                     1130
#define CMD_STATUS                  1140
#define CMD_STOR                    1150

#define CMD_TYPE_I                  1170
#define CMD_TYPE_A                  1180

#define CMD_SHFLAGS                 1200

// under OPTIONS popup menu
#define OPT_SETVIEWER               1410

#define IDM_ABOUT                   1500
#define IDM_EXIT                    1600
#define IDM_DROPFILES               1610

// **** main window child window identifiers
// TXT = static text windows
// LST = list boxes
// BTN = push buttons
// RB  = radio buttons

// local side child windows

#define LST_DELFILES                2095

#define EDT_LFILETYPE               2105
#define TXT_LDIRECTORY              2110
#define LST_LDIRS                   2120
#define LST_LDIRLST                 2125
#define LST_LFILES                  2130
#define BTN_LCHANGE                 2140
#define BTN_LMKDIR                  2150
#define BTN_LRMDIR                  2160
#define BTN_LREFRESH                2175
#define BTN_LHISTORY                2185
#define BTN_LDISPLAY                2170
#define BTN_LRENAME                 2180
#define BTN_LDELETE                 2190

// remote side child windows
#define TXT_HOSTNAME                2200

#define EDT_RFILETYPE               2205
#define TXT_RDIRECTORY              2210
#define LST_RDIRS                   2220
#define LST_RDIRLST                 2225
#define LST_RFILES                  2230
#define BTN_RCHANGE                 2240
#define BTN_RMKDIR                  2250
#define BTN_RRMDIR                  2260
#define BTN_RREFRESH                2275
#define BTN_RHISTORY                2285
#define BTN_RDISPLAY                2270
#define BTN_RRENAME                 2280
#define BTN_RDELETE                 2290

// transfer buttons
#define BTN_LOCAL_TO_REMOTE         2310
#define BTN_REMOTE_TO_LOCAL         2320

// configuration buttons
#define RB_ASCII                    2410
#define RB_BINARY                   2411
#define RB_L8                       2412

// information text windows
#define TXT_STATUS                  2510
#define TXT_RBYTES                  2520
#define TXT_LBYTES                  2530

// control buttons
#define BTN_CONNECT                 2610
#define BTN_CLOSE                   2620
#define BTN_LONG                    2630
#define BTN_ABORT                   2635
#define BTN_OPTION                  2640
#define BTN_ABOUT                   2645
#define BTN_EXIT                    2650

// input dialog controls
#define DLG_PROMPT                  3010
#define DLG_EDIT                    3020

// **** connect dialog box controls
#define DLG_EDT_HOST                4010
#define DLG_EDT_USERID              4020
#define DLG_EDT_PASSWD              4030
#define DLG_HOST_TIMEOUT            4040

// **** status dlg identifiers
#define CKB_BELL                    5010
#define CKB_CRSTRIP                 5020
#define CKB_GLOBBING                5030
#define CKB_HASH                    5040
#define CKB_PROMPT                  5050
#define CKB_INTERACTIVE             5060
#define CKB_MCASE                   5070
#define CKB_PORT_CMDS               5080
#define CKB_RECV_UNIQUE             5090
#define CKB_STOR_UNIQUE             5100
#define CKB_VERBOSE                 5110
#define CKB_AUTOSTART               5120
#define BTN_OPTIONS                 5130
#define DLG_MAILADDR                5250

#define RB_SHOWCHECKS 8100

// **** misc definitions
#define TYPE_I 'I'
#define TYPE_A 'A'
#define TYPE_E 'E'
#define TYPE_L 'L'

#define FORM_N 'N'
#define FORM_T 'T'
#define FORM_C 'C'

#define MODE_S 'S'
#define MODE_B 'B'
#define MODE_C 'C'

#define DBUGWNDCLASS "WSDBUGWNDCLASS"

struct win_info 
{
  HWND hWnd;
  int nLineHeight;
  int nScreenRows;
  int nMemPtr;
  int nVpos;
  LPSTR lpDebugMsg;
  LPSTR lpMem[100];
};

typedef struct HostConfig
{
  char szConfig[80];
  char szHostName[80];
} HOSTCONFIG, * LPHOSTCONFIG;

typedef struct HostInfo
{
  char szConfig[80];
  char szHostName[80];
  char szUserID[80];
  char szPassword[80];
  char szInitDir[80];
  char szScript[80];
  int  nType;
  BOOL bSaveDir;
  BOOL bFireWall;
  UINT nTimeOut;
} HOSTINFO, * LPHOSTINFO;

typedef struct 
{
  char szViewer[80];
  char szDir[80];
  char szExt[10];
  char nTyp;
} VIEWERCFG, *LPVIEWERCFG;

// **** function prototypes

// in ws_child.c
int CreateSubWindows (HWND,HWND);
int GetLocalDirForWnd (HWND);
int GetRemoteDirForWnd(HWND);
int ReadProcessHelp (HWND, SOCKET);
int DoMainPaint (HWND hWnd);
int GetButtonStatus (int);
int GetButtonMsgStatus (int);
int SetButtonStatus (int, int);
int FindButtonClicked (int, int);
int DoPaintButton (HWND, int, int);
int GetButtonID (int);
int SetStatus (HWND, LPSTR);
int ScrollStatus (HWND, int);
int UnsetStatusLines();
int GetChildWindowID (LPARAM);
int GetMaxStatusLines();

BOOL SetButtonEnabledStatus (int, BOOL);
BOOL GetButtonEnabledStatus (int);

void ShowOurFlags (void);
void CreateButtonPens (void);
void DeleteButtonPens (void);
void BoxIt (HDC, int, int, int, int, BOOL);

LPSTR FindName (LPSTR);
LPSTR GetStatusLine (int nLine);

// in ws_con.c
int getreply (SOCKET, LPSTR, BOOL);
int command (SOCKET socket, char *fmt,...);
int DoSTAT (SOCKET);
int DoCHMOD (SOCKET,LPSTR,LPSTR);
int DoCWD (SOCKET,LPSTR);
int DoSystemCommand (SOCKET);
int DoDirList (SOCKET,LPSTR);
int DoDELE (SOCKET,LPSTR);
int DoDisconnect (SOCKET);
int DoMKD (SOCKET,LPSTR);
int DoPWD (SOCKET);
int DoQUOTE (SOCKET,LPSTR);
int DoRMD (SOCKET,LPSTR);
int DoDirList (SOCKET,LPSTR);
int SendFile (SOCKET,LPSTR,LPSTR,char);
int RetrieveFile (SOCKET,LPSTR,LPSTR,char);
int SendPacket (SOCKET,LPSTR);
int ForcePacket (SOCKET,LPSTR);
int ReadDisplayLine (SOCKET);
int ReadLine (SOCKET);
int SendMass (SOCKET,LPSTR filename,BOOL);
int ReadMass (SOCKET,LPSTR filename,BOOL);
int ForceCommand (SOCKET s, LPSTR lpCmd, ...);
char *onoff (BOOL);
SOCKET DoClose (SOCKET sockfd);
SOCKET DoConnect (LPSTR);
SOCKET GetFTPListenSocket (SOCKET sockfd);

// in ws_ip.c
SOCKET connectsock (char *host,char *service,char *protocol);
SOCKET connectTCP (char *host,char *service);
SOCKET connectUDP (char *host,char *service);
int sendstr (SOCKET sockfd,LPSTR ptr,int nbytes, int *lpCode);

// in ws_debug.c
int CreateDebugWindow (HWND hMainWnd,HWND hInst);
LRESULT CALLBACK DebugWndProc (HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam);
void SetDebugWindowText (LPSTR);

// in ws_error.c
LPSTR ReturnWSError(UINT Err,LPSTR lpszBuf);
void ReportWSError(LPSTR lpszMsg,UINT Err);

// in ws_main.c

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_AboutMsgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_HostMsgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_InputMsgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_DeleteProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_StatMsgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_FireWallSetupProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam);

int SubProcessAsync (HWND, UINT, WPARAM, LPARAM);
int InitInstance (HINSTANCE);
int ExecFTPApp (int);
int CheckMsgQueue (HWND);
int FindViewerIndex (LPSTR);
int AddDirToList (HWND, int, LPSTR);
int OnCmdLocalChangeDirLst (HWND);
int OnCmdLocalChangeDir (HWND);
int OnCmdLocalToRemote (HWND);
int OnCmdLocalMakeDir (HWND);
int OnCmdLocalRemoveDir (HWND);
int OnCmdLocalDeleteFile (HWND);
int OnCmdLocalRenameFile (HWND);
int OnCmdLocalHistory (HWND);
int OnCmdLocalDisplay (HWND);
int OnCmdLButtonDblClkLocal (HWND);
int OnCmdLocalRefresh (HWND);
int OnCmdRemoteMakeDir (HWND);
int OnCmdRemoteRemoveDir (HWND);
int OnCmdRemoteDeleteFile (HWND);
int OnCmdRemoteRenameFile (HWND);
int OnCmdRemoteChangeDir (HWND);
int OnCmdRemoteChangeDirLst (HWND);
int OnCmdRemoteToLocal (HWND);
int OnCmdRemoteRefresh (HWND);
int OnCmdRemoteHistory (HWND);
int OnCmdRemoteDisplay (HWND);
int OnCmdLButtonDblClkRemote (HWND);
int OnShowTransferType (HWND);
int OnCmdConnectHost (HWND, WORD);
int OnCmdListHost (HWND);
int OnCmdNListHost (HWND, WORD);
int OnCmdLogToFile (HWND, WORD);
int OnCmdLogFileName (HWND, WORD);
int OnCmdHelpHost (HWND);
int OnCmdStatusHost (HWND);
int OnCmdPWDHost (HWND);
int OnCmdDirOpHost (HWND, WORD);
int OnCmdGetFileHost (HWND);
int OnCmdPutFileHost (HWND);
int OnCmdQuoteHost (HWND);
int OnCmdGetCwdHost (HWND);
int OnCmdAbort (HWND);
int OnCmdAbout (HWND);
int OnCmdShowDebug (HWND, WORD);
int OnCmdSaveDir (HWND, WORD);
int OnCmdGetHostAddr (HWND, WORD);
int OnCmdLFileType (HWND, WORD);
int OnCmdRFileType (HWND, WORD);
int OnCmdCloseOrExit (HWND, WPARAM);
int nCwRegisterClasses (void );

void CleanupTempFiles (HWND);
void CreateTempFileNames (LPSTR);
void GetViewerInfo (HWND);
void SetViewerInfo (HWND, int);
void cwCenter (HWND, int);
void CwUnRegisterClasses (void );

LPSTR GetViewer (LPSTR, LPSTR, LPSTR);
LPSTR FindViewerName (LPSTR);

LRESULT OnCreate (HWND, UINT, WPARAM, LPARAM);
LRESULT OnTimer (HWND, UINT, WPARAM, LPARAM);
LRESULT OnWmCmd (HWND, UINT, WPARAM, LPARAM);
LRESULT OnSetCursor (HWND, UINT, WPARAM, LPARAM);
LRESULT OnPaint (HWND, UINT, WPARAM, LPARAM);
LRESULT OnRButtonDown (HWND, UINT, WPARAM, LPARAM);
LRESULT OnRButtonUp (HWND, UINT, WPARAM, LPARAM);
LRESULT OnLButtonDown (HWND, UINT, WPARAM, LPARAM);
LRESULT OnLButtonUp (HWND, UINT, WPARAM, LPARAM);
LRESULT OnMouseMove (HWND, UINT, WPARAM, LPARAM);
LRESULT OnVScroll (HWND, UINT, WPARAM, LPARAM);
LRESULT OnCtlColor (HWND, UINT, WPARAM, LPARAM);
LRESULT OnClose (HWND, UINT, WPARAM, LPARAM);
LRESULT OnSetFocus (HWND, UINT, WPARAM, LPARAM);
LRESULT OnKillFocus (HWND, UINT, WPARAM, LPARAM);
LRESULT OnParentNotify (HWND, UINT, WPARAM, LPARAM);
LRESULT OnDragDropFile (HWND, UINT, WPARAM, LPARAM);

// in ws_paint.c
void ReleaseDisplayMem (VOID);
void DoAddLine (LPSTR);
void DoPrintf (char *fmt,...);
void DoPaint (HWND);
int GetLocalInfo (void);  

//in ws_host.c
int  MakeLocalName(LPSTR szLocalName, LPSTR szRemoteName);
int  ConvertTargetDir (LPSTR lpDir, int nSiz);
int  ConvertSourceDir (LPSTR lpBuf, LPSTR lpDir, int nSiz);
int RetrieveDirList (HWND);
int SaveDirList (HWND);
int UpdateDirListOpt (HWND, BOOL);
void SaveUserInfo();
void LoadUserInfo();
void SetViewTyp (int, char);
LPSTR GetHostName (int nI);
LPSTR GetHostType (int nI);
LPSTR GetHostTypeValue (int nI);
LPSTR lpVuExt (int);
LPSTR lpVuPgm (int);
LPSTR lpVuDir (int);
LPSTR ReAllocViewer (int);
char GetViewTyp (int);

//in ws_local.c
int OnCmdDropFiles (HWND hWnd, LPSTR *lParam);
int OnCmdDisplayHostList (HWND hWnd, WORD wCtlID, WORD wNotifyCode);
int DoRunScript (HWND hWnd, LPSTR lpScript);
int OnCmdZoomInfo (HWND);
void ClearZoomInfo();
void AddMessageToView (LPSTR lpBuf, LPSTR lpHdr);
void CreateUniqueName (LPSTR localname, LPSTR szName, LPSTR Ext);
void SetTotalBytes (LONG lBytes);
void SetXmitBytes (LONG lBytes);
void OnPaintXfer (HWND hWnd);
void CreateXferWindow();
void DeleteXferWindow();
void SetXferWindowText (LPSTR lpStr);
LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WndMsgProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);

//in ws_icmp.c
BOOL CALLBACK WS_FindHostProc (HWND, UINT, WPARAM, LPARAM);

#ifdef WIN32
   #define setdisk(x)                  _chdrive (x)
#else
   #define setdisk(x)                  { int nDrv; _dos_setdrive (x, &nDrv); }   
#endif

#define UNREFERENCED_PARAMETER(x)   (x)

#define DLG_HOST_ANONY              101
#define DLG_HOST_SAVE               102
#define DLG_HOST_PWD                103

#define HOST_AUTO                     0
#define HOST_UNIX                     1
#define HOST_IBM_VM                   2
#define HOST_VMS_MULTINET             3
#define HOST_VMS_UCX                  4
#define HOST_PCTCP                    5
#define HOST_NCSA                     6
#define HOST_NOS                      7
#define HOST_QVT                      8
#define HOST_IBM_TCP                  9
#define HOST_CHAMELEON               10
#define HOST_SUPER                   11
#define HOST_SINTFTPD                12
#define HOST_MVS                     13
#define HOST_U5000                   14

#define DLG_HOST_AUTO              (6000+HOST_AUTO)
#define DLG_HOST_UNIX              (DLG_HOST_AUTO+HOST_UNIX)
#define DLG_HOST_IBM_VM            (DLG_HOST_AUTO+HOST_IBM_VM)
#define DLG_HOST_VMS_MULTINET      (DLG_HOST_AUTO+HOST_VMS_MULTINET)
#define DLG_HOST_VMS_UCX           (DLG_HOST_AUTO+HOST_VMS_UCX)
#define DLG_HOST_PCTCP             (DLG_HOST_AUTO+HOST_PCTCP)
#define DLG_HOST_NCSA              (DLG_HOST_AUTO+HOST_NCSA)
#define DLG_HOST_QVT               (DLG_HOST_AUTO+HOST_QVT)
#define DLG_HOST_NOS               (DLG_HOST_AUTO+HOST_NOS)
#define DLG_HOST_IBM_TCP           (DLG_HOST_AUTO+HOST_IBM_TCP)
#define DLG_HOST_CHAMELEON         (DLG_HOST_AUTO+HOST_CHAMELEON)
#define DLG_HOST_SUPER             (DLG_HOST_AUTO+HOST_SUPER)
#define DLG_HOST_SINTFTPD          (DLG_HOST_AUTO+HOST_SINTFTPD)
#define DLG_HOST_MVS               (DLG_HOST_AUTO+HOST_MVS)
#define DLG_HOST_U5000             (DLG_HOST_AUTO+HOST_U5000)

#define DLG_HOST_LAST              DLG_HOST_U5000

#define DLG_HOST_DIR                105

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

