#ifndef __1DBARENCODELIB_H__
#define __1DBARENCODELIB_H__

#include <windows.h>
#include <wingdi.h>

typedef struct  
{
	int  symbology;
	int  height;
	int  whiteSpaceWidth;
	int  borderWidth;
	int  outputOptions;
	int  rotateAngle;
	int  rows;
	int  width;
	int  charSize;
	int  textAlign;
	char *charSet;
	char *prefix;
	char *surfix;
	COLORREF foreColor;
	COLORREF backColor;
	char text[100];
	char encodedData[8][1000];
	char errtxt[100];
}_SYMBOL;

#define BARCODE_CODE11		1
#define BARCODE_C25MATRIX	2
#define BARCODE_C25INTER	3
#define BARCODE_C25IATA		4
#define BARCODE_C25LOGIC	6
#define BARCODE_C25IND		7
#define BARCODE_CODE39		8
#define BARCODE_EXCODE39	9
#define BARCODE_EANX		13
#define BARCODE_EAN128		16
#define BARCODE_CODABAR		18
#define BARCODE_CODE128		20
#define BARCODE_DPLEIT		21
#define BARCODE_DPIDENT		22
#define BARCODE_CODE16K		23
#define BARCODE_CODE93		25
#define BARCODE_FLAT		28
#define BARCODE_TELEPEN		32
#define BARCODE_UPCA		34
#define BARCODE_UPCE		37
#define BARCODE_POSTNET		40
#define BARCODE_MSI_PLESSEY	47
#define BARCODE_FIM			49
#define BARCODE_LOGMARS		50
#define BARCODE_PHARMA		51
#define BARCODE_PZN			52
#define BARCODE_PHARMA_TWO	53
#define BARCODE_PDF417		55
#define BARCODE_PDF417TRUNC	56
#define BARCODE_MAXICODE	57
#define BARCODE_QRCODE		58
#define BARCODE_CODE128B	60
#define BARCODE_AUSPOST		63
#define BARCODE_AUSREPLY	66
#define BARCODE_AUSROUTE	67
#define BARCODE_AUSREDIRECT	68
#define BARCODE_ISBNX		69
#define BARCODE_RM4SCC		70
#define BARCODE_DATAMATRIX	71
#define BARCODE_ITF14		72
#define BARCODE_NVE18		75
#define BARCODE_KOREAPOST	77
#define BARCODE_PLANET		82
#define BARCODE_MICROPDF417	84
#define BARCODE_ONECODE		85
#define BARCODE_PLESSEY		86
#define BARCODE_TELEPEN_NUM	100
#define BARCODE_MSI_10		101
#define BARCODE_MSI_10_10	102
#define BARCODE_MSI_11		103
#define BARCODE_MSI_11_10	104
#define BARCODE_CODE39_43	105
#define BARCODE_EXCODE39_43	106

#define BARCODE_NO_ASCII	1
#define BARCODE_BIND		2
#define BARCODE_BOX			4

#define WARN_INVALID_OPTION	2
#define ERROR_TOO_LONG		5
//#define ERROR_INVALID_DATA	6
#define ERROR_INVALID_CHECK		7
#define ERROR_INVALID_OPTION	8
#define ERROR_ENCODING_PROBLEM	9
#define ERROR_FILE_ACCESS		10
#define ERROR_MEMORY			11

void _InitBarcodeContext(_SYMBOL *pSymbol);
BOOL _FreeBarcodeContext();
HBITMAP _1DBarEncode2Bitmap(_SYMBOL *pSymbol);
BOOL _1DBarEncode2File(_SYMBOL *pSymbol,LPCTSTR pImageFile);



#endif /* __1DBARENCODELIB_H__ */
