/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import unity.operators.Operator;
import unity.predicates.SortComparator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class SortSetOp
extends Operator {
    protected SortComparator sorter;
    private int opType;
    private Tuple tupleLeft;
    private Tuple tupleRight;

    public SortSetOp(Operator[] children, SortComparator sort, Relation outputRelation, int oType) {
        super(children, 0, 0);
        this.sorter = sort;
        this.opType = oType;
        this.setOutputRelation(outputRelation);
    }

    public void init() throws IOException {
        this.input[0].init();
        this.input[1].init();
        this.tupleLeft = this.input[0].next();
        this.tupleRight = this.input[1].next();
        this.incrementTuplesRead(2);
    }

    public Tuple next() throws IOException {
        boolean leftSmaller;
        if (this.tupleLeft == null && this.tupleRight == null) {
            return null;
        }
        if (this.tupleLeft == null) {
            Tuple saved = this.tupleRight;
            this.tupleRight = this.input[1].next();
            return saved;
        }
        if (this.tupleRight == null) {
            Tuple saved = this.tupleLeft;
            this.tupleLeft = this.input[0].next();
            return saved;
        }
        boolean bl = leftSmaller = this.sorter.sqlcompare(this.tupleLeft, this.tupleRight) < 0;
        Tuple output = leftSmaller ? this.tupleLeft : this.tupleRight;
        while (this.tupleLeft != null && this.sorter.sqlcompare(this.tupleLeft, output) == 0) {
            this.tupleLeft = this.input[0].next();
        }
        while (this.tupleRight != null && this.sorter.sqlcompare(output, this.tupleRight) == 0) {
            this.tupleRight = this.input[1].next();
        }
        return output;
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(30);
        sb.append("SET UNION (sort-based): ");
        return sb.toString();
    }
}

