/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import unity.operators.Operator;
import unity.predicates.SortComparator;
import unity.relational.Tuple;

public class SortEliminator
extends Operator {
    private Tuple lastTupleRead;
    protected SortComparator sorter;

    public SortEliminator(Operator in, SortComparator s) {
        super(new Operator[]{in}, 0, 0);
        this.sorter = s;
        this.setOutputRelation(in.getOutputRelation());
    }

    public void init() throws IOException {
        this.input[0].init();
        this.lastTupleRead = new Tuple(this.outputRelation);
        this.incrementTuplesRead();
    }

    public Tuple next() throws IOException {
        Tuple next = this.input[0].next();
        while (next != null && this.sorter.sqlcompare(next, this.lastTupleRead) == 0) {
            next = this.input[0].next();
        }
        if (next == null) {
            return null;
        }
        this.lastTupleRead = next;
        return next;
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "duplicate elimination";
    }
}

