/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import unity.annotation.AnnotatedSourceDatabase;
import unity.globalschema.GlobalSchema;
import unity.io.FileManager;
import unity.jdbc.UnityConnection;
import unity.query.LQExprNode;
import unity.util.VerifySystem;

public class UnityDriver
implements Driver {
    public static final int _MAJORVERSION = 1;
    public static final int _MINORVERSION = 0;
    public static String DRIVER_NAME = "UnityJDBC";
    public static boolean DEBUG = false;

    static {
        try {
            DriverManager.registerDriver(new UnityDriver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Failed to register UnityJDBC Driver.");
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        BufferedReader reader;
        int tm = (int)System.currentTimeMillis();
        if (tm % 5 == 0) {
            VerifySystem.verifyReg();
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        int paramPos = url.indexOf("?");
        if (paramPos > 0) {
            String params = url.substring(paramPos + 1);
            StringTokenizer myTokenizer = new StringTokenizer(params, "=&");
            while (myTokenizer.hasMoreTokens()) {
                String val = myTokenizer.nextToken();
                if (!val.equalsIgnoreCase("debug") || !myTokenizer.hasMoreTokens() || !(val = myTokenizer.nextToken()).equalsIgnoreCase("true")) continue;
                DEBUG = true;
            }
            url = url.substring(0, paramPos);
        }
        int position = url.indexOf("jdbc:Unity://");
        String fileName = url.substring(position + 13);
        try {
            reader = url.indexOf(".xme") > 0 ? new BufferedReader(new InputStreamReader(FileManager.getDecryptedStream(fileName, info.getProperty("password")))) : new BufferedReader(new InputStreamReader(FileManager.getStream(fileName)));
        }
        catch (IOException e) {
            throw new SQLException("Unable to retrieve connection information at: " + fileName);
        }
        GlobalSchema gs = new GlobalSchema();
        gs.createAnnotatedSources(reader, url);
        boolean immediateConnect = false;
        String userConnect = info.getProperty("connectNow");
        if (userConnect != null && userConnect.equals("true")) {
            immediateConnect = true;
        }
        if (immediateConnect) {
            ArrayList dbs = new ArrayList();
            dbs = gs.getAnnotatedDatabases();
            try {
                int i = 0;
                while (i < dbs.size()) {
                    AnnotatedSourceDatabase db = (AnnotatedSourceDatabase)dbs.get(i);
                    Class.forName(db.getJavaDriverName()).newInstance();
                    Connection conn = DriverManager.getConnection(db.getURLJava());
                    db.setConnection(conn);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new SQLException("Connection error: " + e.toString());
            }
        }
        UnityConnection unityconn = new UnityConnection(gs, info);
        LQExprNode.loadFunctions();
        return unityconn;
    }

    public boolean acceptsURL(String url) throws SQLException {
        int position = url.indexOf("jdbc:Unity://");
        return position >= 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

