/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.MatchFunction;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class M_Sum
extends MatchFunction {
    protected boolean isIntType;

    public M_Sum(Expression exp1, Expression exp2) {
        super(exp1, exp2);
        this.returnType = exp1.getReturnType();
        this.isIntType = this.returnType == Attribute.TYPE_INT;
    }

    public Object evaluate(Tuple t) {
        Object val1 = this.attr1Expr.evaluate(t);
        Object val2 = this.attr2Expr.evaluate(t);
        if (val1 == null && val2 == null) {
            return null;
        }
        if (this.isIntType) {
            int tmpVal = 0;
            if (val1 != null) {
                tmpVal += ((Number)val1).intValue();
            }
            if (val2 != null) {
                tmpVal += ((Number)val2).intValue();
            }
            return new Integer(tmpVal);
        }
        double tmpVal = 0.0;
        if (val1 != null) {
            tmpVal += ((Number)val1).doubleValue();
        }
        if (val2 != null) {
            tmpVal += ((Number)val2).doubleValue();
        }
        return new Double(tmpVal);
    }

    public String toString(Relation relation, Attribute outputAttribute) {
        String st = "SUM(" + this.attr1Expr.toString(relation) + ", " + this.attr2Expr.toString(relation) + ")";
        if (outputAttribute != null) {
            return String.valueOf(st) + " AS " + outputAttribute.getName();
        }
        return st;
    }
}

