/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Replace
extends Function {
    private Expression sourceString;
    private Expression searchString;
    private Expression replaceString;

    public F_Replace(Expression source, Expression search, Expression replace) {
        this.sourceString = source;
        this.searchString = search;
        this.replaceString = replace;
    }

    public Object evaluate(Tuple t) {
        String source = (String)this.sourceString.evaluate(t);
        if (source == null) {
            return null;
        }
        String search = (String)this.searchString.evaluate(t);
        if (search == null) {
            return source;
        }
        String replace = (String)this.replaceString.evaluate(t);
        if (replace == null) {
            return source;
        }
        return source.replaceAll(search, replace);
    }

    public int getReturnType() {
        return Attribute.TYPE_STRING;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_STRING, Attribute.TYPE_STRING, Attribute.TYPE_STRING};
    }

    public static String getFunctionName() {
        return "REPLACE";
    }

    public String toString(Relation relation) {
        return "REPLACE(" + this.sourceString.toString(relation) + "," + this.searchString.toString(relation) + "," + this.replaceString.toString(relation) + ")";
    }
}

