/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseImplConnection;
import java.sql.SQLException;
import java.util.Vector;

public final class BaseConnectionPool {
    private static String footprint = "$Revision:   1.5.1.0  $";
    Vector physicalConnectionPool = new Vector();

    protected void add(BaseImplConnection baseImplConnection) {
        this.physicalConnectionPool.addElement(baseImplConnection);
    }

    public void close() {
        int n = this.physicalConnectionPool.size();
        int n2 = 0;
        while (n2 < n) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n2);
            if (baseImplConnection.getReferenceCount() == 0) {
                try {
                    baseImplConnection.close();
                }
                catch (SQLException sQLException) {}
            }
            ++n2;
        }
    }

    protected int count() {
        return this.physicalConnectionPool.size();
    }

    protected int countActiveConnections() {
        int n = 0;
        int n2 = this.physicalConnectionPool.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n3);
            if (baseImplConnection.getReferenceCount() > 0) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    protected int countUseableConnections(int n) {
        int n2 = 0;
        int n3 = this.physicalConnectionPool.size();
        int n4 = 0;
        while (n4 < n3) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n4);
            if (baseImplConnection.getReferenceCount() < n) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    protected void finalize() {
        this.close();
    }

    protected BaseImplConnection getUseableConnection(int n) {
        BaseImplConnection baseImplConnection = null;
        int n2 = this.physicalConnectionPool.size();
        int n3 = 0;
        while (n3 < n2) {
            baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n3);
            if (baseImplConnection.getReferenceCount() < n) break;
            ++n3;
        }
        return baseImplConnection;
    }

    public void reset() throws SQLException {
        int n = this.physicalConnectionPool.size();
        int n2 = 0;
        while (n2 < n) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n2);
            baseImplConnection.reset();
            ++n2;
        }
    }

    public void setCatalog(String string) throws SQLException {
        int n = this.physicalConnectionPool.size();
        int n2 = 0;
        while (n2 < n) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n2);
            baseImplConnection.setCatalog(string);
            ++n2;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        int n2 = this.physicalConnectionPool.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n3);
            baseImplConnection.setTransactionIsolation(n);
            ++n3;
        }
    }
}

