/*
 * Decompiled with CFR 0.152.
 */
package komponens.kep;

import freejava.Mindenes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import komponens.szoveg.TextErtelmezo;

public class KepNezoPanel
extends JPanel
implements Scrollable {
    private Image kep;
    private Color hatterSzin = TextErtelmezo.hatterColor;
    private double nagyitas = 1.0;
    private Component component;

    public KepNezoPanel(Component component, String string) {
        try {
            this.kep = Mindenes.isURL(string) ? Toolkit.getDefaultToolkit().getImage(new URL(string)) : Toolkit.getDefaultToolkit().getImage(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.component = component;
        new ImageIcon(this.kep);
        this.setPreferredSize(new Dimension(this.kep.getWidth(this), this.kep.getHeight(this)));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.hatterSzin);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.kep, this.getKepX(), this.getKepY(), (int)((double)this.kep.getWidth(this) * this.nagyitas), (int)((double)this.kep.getHeight(this) * this.nagyitas), this.hatterSzin, this);
    }

    public void setNagyitas(double d) {
        this.nagyitas = d;
        this.setPreferredSize(new Dimension((int)((double)this.kep.getWidth(this) * d), (int)((double)this.kep.getHeight(this) * d)));
        this.revalidate();
        this.repaint();
    }

    public double getNagyitas() {
        return this.nagyitas;
    }

    public void setHatterSzin(Color color) {
        this.hatterSzin = color;
        this.repaint();
    }

    public Color getHatterSzin() {
        return this.hatterSzin;
    }

    public String getPixelMeret() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.kep.getWidth(this)))).append(" x ").append(this.kep.getHeight(this))));
    }

    public Image getKep() {
        return this.kep;
    }

    public int getKepY() {
        int n = this.getPreferredSize().height;
        return n < this.component.getHeight() ? this.component.getHeight() / 2 - (int)((double)this.kep.getHeight(this) * this.nagyitas / (double)2) : 0;
    }

    public int getKepX() {
        int n = this.getPreferredSize().width;
        return n < this.component.getWidth() ? this.component.getWidth() / 2 - (int)((double)this.kep.getWidth(this) * this.nagyitas / (double)2) : 0;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.kep.getWidth(this) * this.nagyitas), (int)((double)this.kep.getHeight(this) * this.nagyitas));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 2;
            }
            case 0: {
                return rectangle.width / 2;
            }
        }
        return 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

